/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required;

import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.telemetry.IssueReportManager;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class}, priority=900)
public abstract class WorldRendererMixin
implements WorldRendererDuck {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private class_4604 field_27740;
    @Shadow
    @Nullable
    private class_4604 field_4056;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    private int field_4073;
    @Shadow
    @Final
    private Vector3d field_4091;
    @Shadow
    @Final
    private class_310 field_4088;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(this.field_4088);
    }

    @Override
    public Renderer betterclouds$getRenderer() {
        return this.cloudRenderer;
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/resource/ResourceManager;)V"})
    private void onReload(class_3300 manager, CallbackInfo ci) {
        block5: {
            if (!BetterClouds.isInitialized()) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            try {
                if (this.cloudRenderer != null) {
                    this.cloudRenderer.reload(manager);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while reloading resources: " + e.getMessage())) break block5;
                throw e;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorld"})
    private void onSetWorld(class_638 world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Unique
    private Vector3d getCapturedFrustumPosition() {
        return new Vector3d((Vector3dc)this.field_4091);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderClouds(class_4587 matrices, Matrix4f viewMat, Matrix4f projMat, float tickDelta, double camX, double camY, double camZ, CallbackInfo ci) {
        block14: {
            if (this.cloudRenderer == null) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            if (this.field_4085 == null) {
                return;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(this.field_4085.method_40134().method_40230().orElse(null))) {
                return;
            }
            if (!BetterClouds.isEnabled()) {
                return;
            }
            ProfilerWrapper.getProfiler().method_15396("betterclouds");
            GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
            Vector3d cam = this.tempVector.set(camX, camY, camZ);
            class_4604 frustum = this.field_27740;
            Vector3d frustumPos = cam;
            if (this.field_4056 != null) {
                frustumPos = this.getCapturedFrustumPosition();
                frustum = this.field_4056;
                frustum.method_23088(frustumPos.x, frustumPos.y, frustumPos.z);
            }
            int ticks = this.field_4073;
            if (Debug.animationPause >= 0) {
                if (Debug.animationPause == 0) {
                    Debug.animationPause = ticks;
                } else {
                    ticks = Debug.animationPause;
                }
                tickDelta = 0.0f;
            }
            try {
                Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
                if (RenderDoc.isFrameCapturing()) {
                    GLCompat.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
                }
                if (prepareResult != Renderer.PrepareResult.FALLBACK) {
                    ci.cancel();
                }
                if (prepareResult == Renderer.PrepareResult.RENDER) {
                    this.cloudRenderer.render(ticks, tickDelta, cam, frustumPos, frustum);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while rendering: " + e.getMessage())) break block14;
                throw e;
            }
        }
        ProfilerWrapper.getProfiler().method_15407();
        GLCompat.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

