/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.FabricSeasonsCompatImpl;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.config.FabricSeasonsConfig;
import com.qendolin.betterclouds.platform.ModLoader;
import com.qendolin.betterclouds.platform.ModVersion;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.class_1937;

public abstract class FabricSeasonsCompat {
    public static final Map<String, Function<FabricSeasonsConfig, Float>> SEASON_CLOUDINESS_LOOKUP = Map.ofEntries(Map.entry("spring", config -> Float.valueOf(config.springCloudiness)), Map.entry("summer", config -> Float.valueOf(config.summerCloudiness)), Map.entry("fall", config -> Float.valueOf(config.fallCloudiness)), Map.entry("winter", config -> Float.valueOf(config.winterCloudiness)));
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static FabricSeasonsCompat instance;
    private static boolean isActive;
    private static final ModVersion.SemVer MINIMUM_VERSION;

    public static void initialize() {
        if (initialized.getAndSet(true)) {
            return;
        }
        if (!ModLoaded.FABRIC_SEASONS) {
            BetterCloudsStatic.getLogger().info("FabricSeasons: not loaded");
            instance = new Stub();
            return;
        }
        BetterCloudsStatic.getLogger().info("FabricSeasons: initializing compat");
        if (!ModLoader.getModVersion("seasons").asSemVer().map(version -> version.compareTo(MINIMUM_VERSION) >= 0).orElse(false).booleanValue()) {
            BetterCloudsStatic.getLogger().error("FabricSeasons version not compatible, minimum required is {}", MINIMUM_VERSION);
            instance = new Stub();
            return;
        }
        try {
            instance = new FabricSeasonsCompatImpl();
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("FabricSeasons version not compatible", e);
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static FabricSeasonsCompat instance() {
        return instance;
    }

    public abstract float getCloudinessFactor(class_1937 var1);

    static {
        isActive = false;
        MINIMUM_VERSION = new ModVersion.SemVer(2, 4, 0);
    }

    protected static class Stub
    extends FabricSeasonsCompat {
        protected Stub() {
        }

        @Override
        public float getCloudinessFactor(class_1937 world) {
            return 1.0f;
        }

        static {
            instance = new Stub();
        }
    }
}

