/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.PerfTimer;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.config.ConfigGUI;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.util.ChatUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.StringRepresentableArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.dimension.DimensionType;

public class Commands {
    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandSourceStack, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        Minecraft client = Minecraft.getInstance();
        dispatcher.register((LiteralArgumentBuilder)Commands.literal("betterclouds:profile").then(Commands.argument("interval", IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            ChatUtil.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:profile").then(Commands.argument("interval", IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            ChatUtil.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        }))).then(Commands.literal("stop").executes(context -> {
            PerfTimer timer;
            ChatUtil.debugChatMessage("profiling.disabled", new Object[0]);
            Debug.profileInterval = 0;
            Renderer renderer = BetterClouds.getCloudsRenderer();
            if (renderer != null && (timer = renderer.resources().timer()) != null) {
                timer.reset();
            }
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:frustum").then(Commands.literal("capture").executes(context -> {
            client.levelRenderer.captureFrustum();
            return 1;
        }))).then(Commands.literal("release").executes(context -> {
            client.levelRenderer.killFrustum();
            return 1;
        }))).then(Commands.literal("debugCulling").then(Commands.argument("enable", BoolArgumentType.bool()).executes(context -> {
            Debug.frustumCulling = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:generator").then(Commands.literal("pause").executes(context -> {
            Debug.generatorPause = true;
            ChatUtil.debugChatMessage("generatorPaused", new Object[0]);
            return 1;
        }))).then(Commands.literal("resume").executes(context -> {
            Debug.generatorPause = false;
            ChatUtil.debugChatMessage("generatorResumed", new Object[0]);
            return 1;
        }))).then(Commands.literal("update").executes(context -> {
            Debug.generatorForceUpdate = true;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:animation").then(((LiteralArgumentBuilder)Commands.literal("pause").executes(context -> {
            Debug.animationPause = 0;
            ChatUtil.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })).then(Commands.argument("ticks", IntegerArgumentType.integer((int)1)).executes(context -> {
            Debug.animationPause = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            ChatUtil.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })))).then(Commands.literal("resume").executes(context -> {
            Debug.animationPause = -1;
            ChatUtil.debugChatMessage("animationResumed", new Object[0]);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:config").then(Commands.literal("open").executes(context -> {
            client.schedule(() -> client.setScreen((Screen)ConfigGUI.create(null)));
            return 1;
        }))).then(Commands.literal("reload").executes(context -> {
            ChatUtil.debugChatMessage("reloadingConfig", new Object[0]);
            ConfigManager.handler().load();
            ChatUtil.debugChatMessage("configReloaded", new Object[0]);
            return 1;
        }))).then(Commands.literal("set").then(Commands.literal("gpuIncompatibleMessage").then(Commands.argument("enable", BoolArgumentType.bool()).executes(context -> {
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            if (ConfigManager.instance().gpuIncompatibleMessageEnabled == enable) {
                return 1;
            }
            ConfigManager.instance().gpuIncompatibleMessageEnabled = enable;
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("updatedPreferences", new Object[0]);
            return 1;
        })))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("betterclouds:dimension").then(Commands.literal("enable").executes(context -> {
            if (client.level == null) {
                return 0;
            }
            Holder entry = client.level.dimensionTypeRegistration();
            ResourceKey key = entry.unwrapKey().orElse(null);
            if (key == null) {
                return 0;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(key)) {
                ConfigManager.instance().enabledDimensions.add((ResourceKey<DimensionType>)key);
            }
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("dimensionAdded", key.location().toString());
            return 1;
        }))).then(Commands.literal("disable").executes(context -> {
            if (client.level == null) {
                return 0;
            }
            Holder entry = client.level.dimensionTypeRegistration();
            ResourceKey key = entry.unwrapKey().orElse(null);
            if (key == null) {
                return 0;
            }
            ConfigManager.instance().enabledDimensions.remove(key);
            ConfigManager.handler().save();
            ChatUtil.debugChatMessage("dimensionRemoved", key.location().toString());
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal("betterclouds:debug").then(Commands.literal("fallback").then(((RequiredArgumentBuilder)Commands.argument("name", FallbackArgumentType.fallback()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enabled = fallback.get(GLCompat.glCompat);
            ChatUtil.debugChatMessage((Component)Component.literal((String)String.format("Fallback %s is currently %s", fallback.getSerializedName(), enabled ? "enabled" : "disabled")));
            return 1;
        })).then(Commands.argument("enable", BoolArgumentType.bool()).executes(context -> {
            FallbackArgument fallback = FallbackArgumentType.getFallback(context, "name");
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            fallback.set(GLCompat.glCompat, enable);
            client.reloadResourcePacks().whenComplete((unused, throwable) -> ChatUtil.debugChatMessage((Component)Component.literal((String)String.format("Fallback %s is now %s", fallback.getSerializedName(), enable ? "enabled" : "disabled"))));
            return 1;
        })))));
    }

    public static void sendGpuIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("gpuIncompatible")).append((Component)Component.literal((String)"\n - ")).append((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("generic.disable")).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY).withClickEvent(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    public static void sendGpuPartiallyIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("gpuPartiallyIncompatible")).append((Component)Component.literal((String)"\n - ")).append((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("generic.disable")).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY).withClickEvent(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    public static void sendHardwareMaybeIncompatibleChatMessage() {
        if (!ConfigManager.instance().gpuIncompatibleMessageEnabled) {
            return;
        }
        ChatUtil.debugChatMessage((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("hwMaybeIncompatible"), (Object[])new Object[]{GLCompat.getCpuInfo(), GLCompat.getRenderer()}).append((Component)Component.literal((String)"\n - ")).append((Component)Component.translatable((String)ChatUtil.debugChatMessageKey("generic.disable")).withStyle(style -> style.withItalic(Boolean.valueOf(true)).withUnderlined(Boolean.valueOf(true)).withColor(ChatFormatting.GRAY).withClickEvent(Commands.createCommandClickEvent("/betterclouds:config set gpuIncompatibleMessage false")))));
    }

    private static ClickEvent createCommandClickEvent(String command) {
        return new ClickEvent.RunCommand(command);
    }

    private static ClickEvent createOpenFileClickEvent(String path) {
        return new ClickEvent.OpenFile(path);
    }

    private static class FallbackArgumentType
    extends StringRepresentableArgument<FallbackArgument> {
        private FallbackArgumentType() {
            super(FallbackArgument.CODEC, FallbackArgument::values);
        }

        public static StringRepresentableArgument<FallbackArgument> fallback() {
            return new FallbackArgumentType();
        }

        public static FallbackArgument getFallback(CommandContext<?> context, String id) {
            return (FallbackArgument)((Object)context.getArgument(id, FallbackArgument.class));
        }
    }

    private static enum FallbackArgument implements StringRepresentable
    {
        BASE_INSTANCE(GLCompat::useBaseInstanceFallback, GLCompat::setUseBaseInstanceFallback),
        STENCIL_TEXTURE(GLCompat::useStencilTextureFallback, GLCompat::setUseStencilTextureFallback),
        TEX_STORAGE(GLCompat::useTexStorageFallback, GLCompat::setUseTexStorageFallback),
        DEPTH_WRITE(GLCompat::useDepthWriteFallback, GLCompat::setUseDepthWriteFallback);

        private static final Codec<FallbackArgument> CODEC;
        private final Function<GLCompat, Boolean> getter;
        private final BiConsumer<GLCompat, Boolean> setter;

        private FallbackArgument(Function<GLCompat, Boolean> getter, BiConsumer<GLCompat, Boolean> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public void set(GLCompat compat, boolean enable) {
            this.setter.accept(compat, enable);
        }

        public boolean get(GLCompat compat) {
            return this.getter.apply(compat);
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(FallbackArgument::values);
        }
    }
}

