/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds.fog;

import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.clouds.fog.FogProvider;
import com.qendolin.betterclouds.compat.SodiumExtraCompat;
import com.qendolin.betterclouds.config.Config;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

class FogProvider1213
implements FogProvider {
    FogProvider1213() {
    }

    @Override
    @Nullable
    public FogProvider.Fog getFogInternal(Minecraft client, Config config, float tickDelta, Camera camera, float distance) {
        assert (client.level != null);
        SodiumExtraCompat.PREVENT_FOG_MODIFICATION.set(true);
        FogParameters original = RenderSystem.getShaderFog();
        Vector4f color = new Vector4f(original.red(), original.green(), original.blue(), original.alpha());
        if ((double)color.w == 0.0) {
            color = FogRenderer.computeFogColor((Camera)camera, (float)tickDelta, (ClientLevel)client.level, (int)client.options.getEffectiveRenderDistance(), (float)client.gameRenderer.getDarkenWorldAmount(tickDelta));
        }
        FogParameters adjusted = FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (Vector4f)color, (float)distance, (boolean)FogProvider1213.shouldUseThickFog(client.level, camera.getPosition()), (float)tickDelta);
        float start = adjusted.start();
        float end = adjusted.end();
        SodiumExtraCompat.PREVENT_FOG_MODIFICATION.set(false);
        RenderSystem.setShaderFog((FogParameters)original);
        return new FogProvider.Fog(start, end, color.x, color.y, color.z, color.w);
    }

    private static boolean shouldUseThickFog(ClientLevel world, Vec3 pos) {
        return world.effects().isFoggyAt(Mth.floor((double)pos.x), Mth.floor((double)pos.z)) || Minecraft.getInstance().gui.getBossOverlay().shouldCreateWorldFog();
    }
}

