/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required;

import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.telemetry.IssueReportManager;
import com.qendolin.betterclouds.util.RenderHelper;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class WorldRendererMixin
implements WorldRendererDuck {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    @Nullable
    private Frustum capturedFrustum;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    private int ticks;
    @Shadow
    @Final
    private LevelTargetBundle targets;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(this.minecraft);
    }

    @Shadow
    public abstract Frustum getCapturedFrustum();

    @Override
    public Renderer betterclouds$getRenderer() {
        return this.cloudRenderer;
    }

    @Inject(at={@At(value="TAIL")}, method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        block5: {
            if (!BetterClouds.isInitialized()) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            try {
                if (this.cloudRenderer != null) {
                    this.cloudRenderer.reload(manager);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while reloading resources: " + e.getMessage())) break block5;
                throw e;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V"})
    private void onSetWorld(ClientLevel world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Unique
    private Vector3d getCapturedFrustumPosition() {
        return new Vector3d(this.getCapturedFrustum().camX, this.getCapturedFrustum().camY, this.getCapturedFrustum().camZ);
    }

    @Inject(at={@At(value="HEAD")}, method={"addCloudsPass(Lcom/mojang/blaze3d/framegraph/FrameGraphBuilder;Lnet/minecraft/client/CloudStatus;Lnet/minecraft/world/phys/Vec3;FIF)V"}, cancellable=true)
    private void renderClouds(FrameGraphBuilder frameGraphBuilder, CloudStatus _mode, Vec3 cameraPos, float _ticks, int _color, float _cloudHeight, CallbackInfo ci) {
        block16: {
            double camX = cameraPos.x;
            double camY = cameraPos.y;
            double camZ = cameraPos.z;
            float tickDelta = Mth.frac((float)_ticks);
            Matrix4f viewMat = RenderHelper.getViewMatrix();
            Matrix4f projMat = RenderHelper.getProjectionMatrix();
            if (this.cloudRenderer == null) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            if (this.level == null) {
                return;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(this.level.dimensionTypeRegistration().unwrapKey().orElse(null))) {
                return;
            }
            if (!BetterClouds.isEnabled()) {
                return;
            }
            ProfilerWrapper.getProfiler().push("betterclouds");
            GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
            Vector3d cam = this.tempVector.set(camX, camY, camZ);
            Frustum frustum = this.cullingFrustum;
            Vector3d frustumPos = cam;
            if (this.capturedFrustum != null) {
                frustumPos = this.getCapturedFrustumPosition();
                frustum = this.capturedFrustum;
                frustum.prepare(frustumPos.x, frustumPos.y, frustumPos.z);
            }
            int ticks = this.ticks;
            if (Debug.animationPause >= 0) {
                if (Debug.animationPause == 0) {
                    Debug.animationPause = ticks;
                } else {
                    ticks = Debug.animationPause;
                }
                tickDelta = 0.0f;
            }
            try {
                Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
                if (RenderDoc.isFrameCapturing()) {
                    GLCompat.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
                }
                if (prepareResult != Renderer.PrepareResult.FALLBACK) {
                    ci.cancel();
                }
                if (prepareResult == Renderer.PrepareResult.RENDER) {
                    FramePass renderPass = frameGraphBuilder.addPass("clouds");
                    if (this.targets.clouds != null) {
                        this.targets.clouds = renderPass.readsAndWrites(this.targets.clouds);
                    } else {
                        this.targets.main = renderPass.readsAndWrites(this.targets.main);
                    }
                    int fticks = ticks;
                    float ftickDelta = tickDelta;
                    Vector3d fcam = cam;
                    Vector3d ffrustumPos = frustumPos;
                    Frustum ffrustum = frustum;
                    renderPass.executes(() -> {
                        block2: {
                            try {
                                ProfilerWrapper.getProfiler().push("clouds");
                                GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
                                this.cloudRenderer.render(fticks, ftickDelta, fcam, ffrustumPos, ffrustum);
                                ProfilerWrapper.getProfiler().pop();
                                GLCompat.glCompat.popDebugGroupDev();
                            }
                            catch (Throwable e) {
                                if (IssueReportManager.handle(e, "An error occurred while rendering: " + e.getMessage())) break block2;
                                throw e;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while rendering: " + e.getMessage())) break block16;
                throw e;
            }
        }
        ProfilerWrapper.getProfiler().pop();
        GLCompat.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close()V"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

