/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.qendolin.betterclouds.compat.BigGlobeCompat;
import com.qendolin.betterclouds.compat.MiddleEarthCompat;
import com.qendolin.betterclouds.config.FabricSeasonsConfig;
import com.qendolin.betterclouds.config.SereneSeasonsConfig;
import com.qendolin.betterclouds.config.ShaderPresetConfig;
import com.qendolin.betterclouds.config.ShaderPresetLoader;
import com.qendolin.betterclouds.util.PreLaunchGuard;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;

public class Config {
    public static final String DEFAULT_PRESET_KEY = "default";
    public static final InstanceCreator<Config> INSTANCE_CREATOR = type -> new Config();
    public static final RegistryKeySerializer REGISTRY_KEY_SERIALIZER = new RegistryKeySerializer();
    @SerialEntry
    public int migrationVersion = 0;
    @SerialEntry
    public boolean enabled = true;
    @SerialEntry
    public float distance = 4.0f;
    @SerialEntry
    public float randomPlacement = 1.0f;
    @SerialEntry
    public float fuzziness = 1.0f;
    @SerialEntry
    public boolean shuffle = false;
    @SerialEntry
    public float yRange = 64.0f;
    @SerialEntry
    public float yOffset = 0.0f;
    @SerialEntry
    public float sparsity = 0.0f;
    @SerialEntry
    public float spacing = 5.25f;
    @SerialEntry
    public float sizeXZ = 16.0f;
    @SerialEntry
    public float sizeY = 8.0f;
    @SerialEntry
    public float travelSpeed = 0.03f;
    @SerialEntry
    public float windEffectFactor = 1.0f;
    @SerialEntry
    public float windSpeedFactor = 0.8f;
    @SerialEntry
    public float colorVariationFactor = 0.8f;
    @SerialEntry
    public boolean celestialBodyHalo = true;
    @SerialEntry
    public int chunkSize = 32;
    @SerialEntry
    public float samplingScale = 1.0f;
    @SerialEntry
    public float scaleFalloffMin = 0.25f;
    @SerialEntry
    public float fogRangeFactor = 1.0f;
    @SerialEntry
    public float fogEndFactor = 1.0f;
    @SerialEntry
    public boolean usePersistentBuffers = true;
    @SerialEntry
    public boolean useFrustumCulling = true;
    @SerialEntry
    public boolean irisSupport = true;
    @SerialEntry
    public boolean cloudOverride = true;
    @SerialEntry
    public boolean useIrisFBO = true;
    @SerialEntry
    public int selectedPreset = 0;
    @SerialEntry
    public List<ShaderPresetConfig> presets = new ArrayList<ShaderPresetConfig>();
    @SerialEntry
    public int lastTelemetryVersion = 0;
    @SerialEntry
    public boolean gpuIncompatibleMessageEnabled = true;
    @SerialEntry
    public boolean issueReportEnabled = true;
    @SerialEntry
    public List<ResourceKey<DimensionType>> enabledDimensions = new ArrayList<ResourceKey<DimensionType>>(Config.getDefaultDimensions());
    @SerialEntry
    public SereneSeasonsConfig sereneSeasonsConfig = new SereneSeasonsConfig();
    @SerialEntry
    public FabricSeasonsConfig fabricSeasonsConfig = new FabricSeasonsConfig();

    public Config() {
    }

    public Config(Config other) {
        this.migrationVersion = other.migrationVersion;
        this.distance = other.distance;
        this.randomPlacement = other.randomPlacement;
        this.fuzziness = other.fuzziness;
        this.shuffle = other.shuffle;
        this.yRange = other.yRange;
        this.yOffset = other.yOffset;
        this.sparsity = other.sparsity;
        this.spacing = other.spacing;
        this.sizeXZ = other.sizeXZ;
        this.sizeY = other.sizeY;
        this.travelSpeed = other.travelSpeed;
        this.windEffectFactor = other.windEffectFactor;
        this.windSpeedFactor = other.windSpeedFactor;
        this.colorVariationFactor = other.colorVariationFactor;
        this.chunkSize = other.chunkSize;
        this.samplingScale = other.samplingScale;
        this.scaleFalloffMin = other.scaleFalloffMin;
        this.fogRangeFactor = other.fogRangeFactor;
        this.fogEndFactor = other.fogEndFactor;
        this.usePersistentBuffers = other.usePersistentBuffers;
        this.irisSupport = other.irisSupport;
        this.enabled = other.enabled;
        this.cloudOverride = other.cloudOverride;
        this.useIrisFBO = other.useIrisFBO;
        this.selectedPreset = other.selectedPreset;
        this.presets = other.presets == null ? new ArrayList<ShaderPresetConfig>() : new ArrayList<ShaderPresetConfig>(other.presets);
        this.presets.replaceAll(ShaderPresetConfig::new);
        this.lastTelemetryVersion = other.lastTelemetryVersion;
        this.gpuIncompatibleMessageEnabled = other.gpuIncompatibleMessageEnabled;
        this.issueReportEnabled = other.issueReportEnabled;
        this.enabledDimensions = other.enabledDimensions == null ? new ArrayList<ResourceKey<DimensionType>>() : new ArrayList<ResourceKey<DimensionType>>(other.enabledDimensions);
        this.celestialBodyHalo = other.celestialBodyHalo;
        this.useFrustumCulling = other.useFrustumCulling;
        this.sereneSeasonsConfig = new SereneSeasonsConfig(other.sereneSeasonsConfig);
        this.fabricSeasonsConfig = new FabricSeasonsConfig(other.fabricSeasonsConfig);
    }

    public void loadDefaultPresets() {
        String selectedDefaultPreset = this.preset().key;
        HashMap<String, ShaderPresetConfig> defaults = new HashMap<String, ShaderPresetConfig>(ShaderPresetLoader.INSTANCE.presets());
        boolean missingDefault = this.presets.stream().noneMatch(preset -> DEFAULT_PRESET_KEY.equals(preset.key));
        this.presets.removeIf(preset -> preset.key != null && !preset.editable && defaults.containsKey(preset.key));
        this.presets.addAll(defaults.values());
        if (selectedDefaultPreset != null) {
            this.presets.stream().filter(preset -> selectedDefaultPreset.equals(preset.key)).findFirst().ifPresentOrElse(prevSelectedPreset -> {
                this.selectedPreset = this.presets.indexOf(prevSelectedPreset);
            }, () -> {
                this.selectedPreset = 0;
            });
        }
        if (missingDefault) {
            this.presets.removeIf(Config::isPresetEqualToEmpty);
            ShaderPresetConfig defaultPreset = (ShaderPresetConfig)defaults.get(DEFAULT_PRESET_KEY);
            if (defaultPreset != null) {
                ShaderPresetConfig defaultCopy = new ShaderPresetConfig(defaultPreset);
                defaultCopy.markAsCopy();
                this.presets.add(defaultCopy);
                this.selectedPreset = this.presets.indexOf(defaultCopy);
            }
        }
        this.sortPresets();
    }

    @NotNull
    public ShaderPresetConfig preset() {
        if (this.presets == null || this.presets.isEmpty()) {
            this.addFirstPreset();
        }
        this.selectedPreset = Mth.clamp((int)this.selectedPreset, (int)0, (int)(this.presets.size() - 1));
        return this.presets.get(this.selectedPreset);
    }

    private static boolean isPresetEqualToEmpty(ShaderPresetConfig preset) {
        if (preset == null) {
            return true;
        }
        String title = preset.title;
        preset.title = ShaderPresetConfig.EMPTY_PRESET.title;
        boolean equal = preset.isEqualTo(ShaderPresetConfig.EMPTY_PRESET);
        preset.title = title;
        return equal;
    }

    public void sortPresets() {
        ShaderPresetConfig selected = this.preset();
        Comparator<ShaderPresetConfig> comparator = Comparator.comparing(preset -> !preset.editable).thenComparing(preset -> !DEFAULT_PRESET_KEY.equals(preset.key)).thenComparing(preset -> preset.title);
        this.presets.sort(comparator);
        this.selectedPreset = this.presets.indexOf(selected);
    }

    public void addFirstPreset() {
        if (this.presets == null) {
            this.presets = new ArrayList<ShaderPresetConfig>();
        }
        if (!this.presets.isEmpty()) {
            return;
        }
        this.presets.add(new ShaderPresetConfig());
    }

    public int blockDistance() {
        return (int)(this.distance * (float)((Integer)Minecraft.getInstance().options.renderDistance().get()).intValue() * 16.0f);
    }

    public static List<ResourceKey<DimensionType>> getDefaultDimensions() {
        return List.of(BuiltinDimensionTypes.OVERWORLD, BigGlobeCompat.DIMENSION_KEY, MiddleEarthCompat.DIMENSION_KEY);
    }

    static {
        PreLaunchGuard.check();
    }

    public static class RegistryKeySerializer
    implements JsonSerializer<ResourceKey<DimensionType>>,
    JsonDeserializer<ResourceKey<DimensionType>> {
        private RegistryKeySerializer() {
        }

        public ResourceKey<DimensionType> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("RegistryKey must be a string");
            }
            try {
                ResourceLocation id = ResourceLocation.parse((String)json.getAsString());
                return ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)id);
            }
            catch (ResourceLocationException e) {
                throw new JsonParseException("Invalid RegistryKey: " + e.getMessage());
            }
        }

        public JsonElement serialize(ResourceKey<DimensionType> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.location().toString());
        }
    }
}

