/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.test;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.platform.EventHooks;
import com.qendolin.betterclouds.test.GameTestEnabled;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GameTest {
    private static final AtomicReference<Throwable> caught = new AtomicReference();
    private static final AtomicBoolean finished = new AtomicBoolean();

    public static void onClientExit() {
        if (!GameTestEnabled.ENABLED) {
            return;
        }
        if (caught.get() != null || !finished.get()) {
            BetterCloudsStatic.getLogger().error("\n========================\n    GameTest failed!    \n========================");
            if (caught.get() != null) {
                throw new RuntimeException(caught.get());
            }
            if (!finished.get()) {
                throw new RuntimeException("Test did not finish!");
            }
        } else {
            BetterCloudsStatic.getLogger().info("\n========================\n    GameTest passed!    \n========================");
        }
    }

    public static void run(Minecraft client) {
        if (!GameTestEnabled.ENABLED) {
            return;
        }
        AtomicBoolean stop = new AtomicBoolean(false);
        TestContext ctx = new TestContext(client);
        EventHooks.instance.onClientTick(c -> {
            if (stop.get()) {
                if (c.isRunning()) {
                    c.stop();
                }
                return;
            }
            ctx.lock.lock();
            try {
                ctx.tick.signalAll();
            }
            finally {
                ctx.lock.unlock();
            }
        });
        Thread timeoutThread = new Thread(() -> {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException ignored) {
                return;
            }
            if (!finished.get()) {
                caught.set(new RuntimeException("GameTest timed out!"));
                stop.set(true);
            }
        });
        Thread testThread = new Thread(() -> {
            try {
                GameTest.runTestAsync(ctx);
                finished.set(true);
            }
            catch (Throwable e) {
                caught.set(e);
            }
            finally {
                stop.set(true);
            }
        });
        timeoutThread.start();
        testThread.setName("Test thread");
        testThread.setDaemon(true);
        testThread.start();
    }

    private static void runTestAsync(TestContext test) {
        test.waitFor(client -> client.getOverlay() == null, 1200L);
        test.runOnClient(client -> {
            client.options.cloudStatus().set((Object)CloudStatus.FANCY);
            boolean exists = client.getLevelSource().levelExists("Game Test");
            if (!exists) {
                throw new RuntimeException("No world 'Game Test', please create it");
            }
            client.createWorldOpenFlows().openWorld("Game Test", () -> {
                throw new RuntimeException("Failed to open 'Game Test' world");
            });
        });
        test.waitFor(client -> client.level != null && client.getSingleplayerServer() != null && client.getSingleplayerServer().isRunning(), 1200L);
        test.waitFor(client -> client.screen == null, 1200L);
        test.waitTicks(20);
        test.runOnClient(client -> {
            assert (client.level != null);
            client.level.disconnect();
            client.disconnect((Screen)new GenericMessageScreen((Component)Component.translatable((String)"menu.savingLevel")));
        });
        test.waitFor(client -> (client.getSingleplayerServer() == null || client.getSingleplayerServer().isRunning()) && client.level == null, 1200L);
    }

    private static class TestContext {
        private final Lock lock = new ReentrantLock();
        private final Condition tick = this.lock.newCondition();
        private final Minecraft client;

        private TestContext(Minecraft client) {
            this.client = client;
        }

        public void runOnClient(Consumer<Minecraft> consumer) {
            Semaphore semaphore = new Semaphore(0);
            AtomicReference caught = new AtomicReference();
            this.client.execute(() -> {
                try {
                    consumer.accept(this.client);
                }
                catch (Throwable e) {
                    caught.set(e);
                }
                finally {
                    semaphore.release();
                }
            });
            semaphore.acquireUninterruptibly();
            if (caught.get() != null) {
                throw new RuntimeException((Throwable)caught.get());
            }
        }

        public void waitFor(Predicate<Minecraft> consumer, long timeout) {
            while (!consumer.test(this.client)) {
                this.waitTick();
                if (--timeout <= 0L) {
                    throw new AssertionError((Object)"Timed out waiting for predicate");
                }
            }
        }

        public void waitTicks(int ticks) {
            for (int i = 0; i < ticks; ++i) {
                this.waitTick();
            }
        }

        public void waitTick() {
            this.lock.lock();
            try {
                this.tick.awaitUninterruptibly();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

