/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.qendolin.betterclouds.clouds.fog.FogProvider;
import com.qendolin.betterclouds.compat.EnhancedCelestialsCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public abstract class EffectTintProvider {
    private static final Vector3f Y = new Vector3f(0.299f, 0.587f, 0.114f);

    public static Vector3f getEffectTint(Minecraft client, @Nullable FogProvider.Fog fog, float tickDelta) {
        if (client.f_91073_ == null || client.f_91074_ == null) {
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
        Vector3f cloudColor = EffectTintProvider.getCloudsColor(client.f_91073_, tickDelta);
        if (EnhancedCelestialsCompat.instance().isEventActive((Level)client.f_91073_)) {
            Vector3f tint = EnhancedCelestialsCompat.instance().getEventTint((Level)client.f_91073_);
            tint.div(0.2f, 0.2f, 1.0f);
            cloudColor.mul((Vector3fc)tint);
        }
        EffectTintProvider.gammaToLinear(cloudColor);
        float cloudBaseLuma = cloudColor.dot((Vector3fc)Y);
        Vector3f cloudBaseChroma = (double)cloudBaseLuma < 1.0E-4 ? new Vector3f(1.0f) : new Vector3f((Vector3fc)cloudColor).div(cloudBaseLuma);
        float cloudLuma = cloudBaseLuma;
        float moon = Mth.m_14036_((float)(-Mth.m_14089_((float)(client.f_91073_.m_46942_(tickDelta) * 2.0f * (float)Math.PI))), (float)-0.25f, (float)0.25f) * 2.0f + 0.5f;
        float moonSize = client.f_91073_.m_46940_() * EnhancedCelestialsCompat.instance().getMoonSize((Level)client.f_91073_);
        Vector4f cry = new Vector4f((Vector3fc)cloudBaseChroma, cloudLuma += moonSize * moon * 0.65f);
        if (fog != null) {
            Vector3f fogColor = new Vector3f(fog.red(), fog.green(), fog.blue());
            EffectTintProvider.compositeColor(fogColor, cry);
        }
        cry.w *= 1.0228087f;
        cry.w = Mth.m_14036_((float)cry.w, (float)0.0f, (float)2.0f);
        float saturation = (float)Math.pow(cry.w, 0.45454545454545453);
        Vector3f gray = new Vector3f(cry.w);
        Vector3f desaturated = new Vector3f(cry.x, cry.y, cry.z).mul(saturation).add((Vector3fc)new Vector3f((Vector3fc)gray).mul(1.0f - saturation));
        Vector3f result = new Vector3f((Vector3fc)desaturated).mul(cry.w).min((Vector3fc)new Vector3f(1.0f));
        EffectTintProvider.linearToGamma(result);
        if (client.f_91074_ != null && client.f_91074_.m_21023_(MobEffects.f_19611_)) {
            float min = result.get(result.minComponent());
            result.div(Mth.m_14179_((float)GameRenderer.m_109108_((LivingEntity)client.f_91074_, (float)tickDelta), (float)1.0f, (float)min));
        }
        return result;
    }

    private static void compositeColor(Vector3f color, Vector4f cry) {
        EffectTintProvider.gammaToLinear(color);
        float luma = color.dot((Vector3fc)Y);
        Vector3f chroma = (double)luma < 1.0E-4 ? new Vector3f(1.0f) : new Vector3f((Vector3fc)color).div(luma);
        cry.set(Mth.m_14116_((float)(chroma.x * cry.x)), Mth.m_14116_((float)(chroma.y * cry.y)), Mth.m_14116_((float)(chroma.z * cry.z)), Mth.m_14207_((float)(Mth.m_14116_((float)luma) + Mth.m_14116_((float)cry.w))) / 4.0f);
    }

    private static Vector3f getCloudsColor(ClientLevel world, float tickDelta) {
        Vector3f Y = new Vector3f(0.299f, 0.587f, 0.114f);
        Vector3f color = new Vector3f(1.0f);
        float rain = world.m_46722_(tickDelta);
        color.lerp((Vector3fc)new Vector3f(color.dot((Vector3fc)Y) * 0.6f), rain * 0.95f);
        float sky = world.m_46942_(tickDelta);
        float sun = Mth.m_14089_((float)(sky * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        sun = Mth.m_14036_((float)sun, (float)0.0f, (float)1.0f);
        color.mul(sun * 0.9f + 0.1f, sun * 0.9f + 0.1f, sun * 0.85f + 0.15f);
        float thunder = world.m_46661_(tickDelta);
        color.lerp((Vector3fc)new Vector3f(color.dot((Vector3fc)Y) * 0.2f), thunder * 0.95f);
        return color;
    }

    private static void gammaToLinear(Vector3f color) {
        color.set((float)Math.pow(color.x, 2.2), (float)Math.pow(color.y, 2.2), (float)Math.pow(color.z, 2.2));
    }

    private static void linearToGamma(Vector3f color) {
        color.set((float)Math.pow(color.x, 0.45454545454545453), (float)Math.pow(color.y, 0.45454545454545453), (float)Math.pow(color.z, 0.45454545454545453));
    }
}

