/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.config.ConfigManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;

public class Buffer
implements AutoCloseable {
    private final boolean usePersistent;
    private final int size;
    private final boolean fancy;
    private final int vaoId;
    private int drawBufferId;
    private int writeBufferId;
    private final int meshId;
    private final int instanceVertexCount;
    private FloatBuffer drawBuffer;
    private FloatBuffer writeBuffer;
    private int swapCount = 0;
    private long prevInstancePointer = -1L;

    public Buffer(int size, boolean fancy, boolean preferPersistent) {
        boolean usePersistent = preferPersistent && (GLCompat.glCompat.arbBufferStorage || GLCompat.glCompat.openGl44);
        this.size = size;
        this.fancy = fancy;
        this.vaoId = GL32.glGenVertexArrays();
        GL32.glBindVertexArray((int)this.vaoId);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_VERTEX_ARRAY, this.vaoId, "clouds_buffer");
        this.meshId = GL32.glGenBuffers();
        GL32.glBindBuffer((int)34962, (int)this.meshId);
        float[] mesh = fancy ? Mesh.FANCY_MESH : Mesh.FAST_MESH;
        this.instanceVertexCount = fancy ? Mesh.FANCY_MESH_VERTEX_COUNT : Mesh.FAST_MESH_VERTEX_COUNT;
        GL32.glBufferData((int)34962, (float[])mesh, (int)35044);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.meshId, "cloud_mesh");
        if (fancy) {
            GL32.glEnableVertexAttribArray((int)1);
            GL32.glEnableVertexAttribArray((int)2);
            GL32.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)24, (long)0L);
            GL32.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)24, (long)12L);
        } else {
            GL32.glEnableVertexAttribArray((int)1);
            GL32.glVertexAttribPointer((int)1, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        }
        this.writeBufferId = GL32.glGenBuffers();
        this.drawBufferId = GL32.glGenBuffers();
        if (size <= 0) {
            BetterCloudsStatic.getLogger().error("Impossible, invalid buffer size of {}, forcing it to 1", size);
            size = 1;
        }
        long vboSize = (long)size * (long)size * 3L * 4L;
        if (usePersistent) {
            try {
                this.allocatePersistent(vboSize);
            }
            catch (IllegalStateException e) {
                ConfigManager.instance().usePersistentBuffers = false;
                ConfigManager.handler().save();
                usePersistent = false;
                BetterCloudsStatic.getLogger().error(e);
            }
        }
        if (!usePersistent) {
            this.allocateMutable(vboSize);
        }
        this.usePersistent = usePersistent;
        GL32.glEnableVertexAttribArray((int)0);
        this.setVAPointerToInstance(0);
        GLCompat.glCompat.vertexAttribDivisor(0, 1);
        Resources.unbindVao();
        Resources.unbindVbo();
    }

    private void allocatePersistent(long vboSize) {
        int flags = 2 | GLCompat.glCompat.GL_MAP_PERSISTENT_BIT | GLCompat.glCompat.GL_MAP_COHERENT_BIT;
        GL32.glBindBuffer((int)34962, (int)this.writeBufferId);
        GLCompat.glCompat.bufferStorage(34962, vboSize, flags);
        ByteBuffer buffer = GL32.glMapBufferRange((int)34962, (long)0L, (long)vboSize, (int)flags);
        if (buffer == null) {
            throw new IllegalStateException("glMapBufferRange returned null");
        }
        this.writeBuffer = buffer.asFloatBuffer();
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.writeBufferId, "cloud_positions_a");
        GL32.glBindBuffer((int)34962, (int)this.drawBufferId);
        GLCompat.glCompat.bufferStorage(34962, vboSize, flags);
        buffer = GL32.glMapBufferRange((int)34962, (long)0L, (long)vboSize, (int)flags);
        if (buffer == null) {
            throw new IllegalStateException("glMapBufferRange returned null");
        }
        this.drawBuffer = buffer.asFloatBuffer();
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.drawBufferId, "cloud_positions_b");
    }

    private void allocateMutable(long vboSize) {
        this.writeBuffer = MemoryUtil.memAllocFloat((int)((int)(vboSize / 4L)));
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.writeBufferId, "cloud_positions");
        GL32.glBindBuffer((int)34962, (int)this.drawBufferId);
        GL32.glBufferData((int)34962, (long)vboSize, (int)35048);
    }

    public void setVAPointerToInstance(int baseInstance) {
        int stride = 12;
        long pointer = (long)stride * (long)baseInstance;
        if (pointer == this.prevInstancePointer) {
            return;
        }
        this.prevInstancePointer = pointer;
        GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)pointer);
    }

    public boolean hasChanged(int size, boolean fancy, boolean persistent) {
        return size != this.size || fancy != this.fancy || ((GLCompat.glCompat.arbBufferStorage || GLCompat.glCompat.openGl44) && persistent) != this.usePersistent;
    }

    public int instanceVertexCount() {
        return this.instanceVertexCount;
    }

    @Override
    public void close() {
        GL32.glDeleteVertexArrays((int)this.vaoId);
        GL32.glDeleteBuffers((int)this.drawBufferId);
        GL32.glDeleteBuffers((int)this.writeBufferId);
        GL32.glDeleteBuffers((int)this.meshId);
        if (!this.usePersistent) {
            MemoryUtil.memFree((java.nio.Buffer)this.writeBuffer);
        }
    }

    public void clear() {
        this.writeBuffer.clear();
    }

    public void put(float x, float y, float z) {
        this.writeBuffer.put(x);
        this.writeBuffer.put(y);
        this.writeBuffer.put(z);
    }

    public void swap() {
        if (this.usePersistent) {
            int tmpId = this.drawBufferId;
            FloatBuffer tmpBuffer = this.drawBuffer;
            this.drawBufferId = this.writeBufferId;
            this.drawBuffer = this.writeBuffer;
            this.writeBufferId = tmpId;
            this.writeBuffer = tmpBuffer;
            GL32.glBindBuffer((int)34962, (int)this.drawBufferId);
            GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        } else {
            GL32.glBindBuffer((int)34962, (int)this.drawBufferId);
            this.writeBuffer.flip();
            GL32.glBufferSubData((int)34962, (long)0L, (FloatBuffer)this.writeBuffer);
        }
        ++this.swapCount;
    }

    public int swapCount() {
        return this.swapCount;
    }

    public void bind() {
        GL32.glBindVertexArray((int)this.vaoId);
    }

    public void bindDrawBuffer() {
        GL32.glBindBuffer((int)34962, (int)this.drawBufferId);
    }

    public void unbind() {
        Resources.unbindVao();
    }
}

