/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.mixin.runtime.RenderPhaseAccessor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;

public class VanillaRenderTarget {
    private final Minecraft client;
    private static final Supplier<String> RENDER_PASS_LABEL = () -> "BetterClouds";
    private final boolean useIris;
    private RenderStateShard renderPhase = null;

    public VanillaRenderTarget(Minecraft client, Config config) {
        this.client = client;
        this.useIris = IrisCompat.instance().isShadersEnabled() && config.useIrisFBO;
    }

    public void begin() {
        if (this.useIris) {
            IrisCompat.instance().bindFramebuffer();
            return;
        }
        RenderTarget framebuffer = this.client.levelRenderer.getCloudsTarget();
        if (framebuffer == null) {
            framebuffer = this.client.getMainRenderTarget();
        }
        framebuffer.bindWrite(false);
        this.renderPhase = RenderPhaseAccessor.getCloudsTarget();
        this.renderPhase.setupRenderState();
    }

    public void end() {
        if (this.useIris) {
            return;
        }
        if (this.renderPhase != null) {
            this.renderPhase.clearRenderState();
        }
    }
}

