/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.EnhancedCelestialsCompat;
import com.qendolin.betterclouds.compat.ReflectAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class EnhancedCelestialsSharedCompatImpl
extends EnhancedCelestialsCompat {
    protected abstract LunarForecastAccess getLunarForecast(Level var1);

    protected abstract ResourceLocation defaultLunarEvent();

    @Override
    public Vector3f getEventTint(Level world) {
        LunarForecastAccess forecast = this.getLunarForecast(world);
        if (forecast == null) {
            return null;
        }
        LunarEventAccess lastEvent = forecast.lastLunarEvent();
        LunarEventAccess currEvent = forecast.currentLunarEvent();
        Vector3f lastColor = lastEvent.getGLSkyLightColor();
        Vector3f currColor = currEvent.getGLSkyLightColor();
        float blend = Mth.clamp((float)forecast.getBlend(), (float)0.0f, (float)1.0f);
        Vector3f delta = currColor.sub((Vector3fc)lastColor, new Vector3f());
        return lastColor.add((Vector3fc)delta.mul(blend), new Vector3f());
    }

    @Override
    public boolean isEventActive(Level world) {
        LunarForecastAccess forecast = this.getLunarForecast(world);
        if (forecast == null) {
            return false;
        }
        LunarEventAccess lastKey = forecast.lastLunarEvent();
        LunarEventAccess currKey = forecast.currentLunarEvent();
        float blend = forecast.getBlend();
        boolean lastActive = !lastKey.matches(this.defaultLunarEvent()) && forecast.switchingEvents();
        boolean currActive = !currKey.matches(this.defaultLunarEvent()) && (double)blend > 0.0;
        return lastActive || currActive;
    }

    @Override
    public float getMoonSize(Level world) {
        LunarForecastAccess forecast = this.getLunarForecast(world);
        if (forecast == null) {
            return 1.0f;
        }
        LunarEventAccess lastEvent = forecast.lastLunarEvent();
        LunarEventAccess currEvent = forecast.currentLunarEvent();
        float lastSize = lastEvent.getMoonSize();
        float currSize = currEvent.getMoonSize();
        return Mth.clampedLerp((float)lastSize, (float)currSize, (float)forecast.getBlend()) / 20.0f;
    }

    protected static abstract class LunarForecastAccess
    extends ReflectAccess {
        public LunarForecastAccess() {
            super("Enhanced Celestials");
        }

        public abstract LunarEventAccess lastLunarEvent();

        public abstract LunarEventAccess currentLunarEvent();

        public abstract float getBlend();

        public abstract boolean switchingEvents();
    }

    protected static abstract class LunarEventAccess
    extends ReflectAccess {
        public LunarEventAccess() {
            super("Enhanced Celestials");
        }

        public abstract Vector3f getGLSkyLightColor();

        public abstract float getMoonSize();

        protected abstract boolean matches(ResourceLocation var1);
    }
}

