/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.renderdoc;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLibrary;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.lwjgl.system.linux.DynamicLinkLoader;

public class RenderDocLoader {
    public static final Path LIB_LINUX_PATH = BetterCloudsStatic.getDataDirectory().resolve("librenderdoc.so");
    public static final Path LIB_WINDOWS_PATH = BetterCloudsStatic.getDataDirectory().resolve("renderdoc.dll");

    private static String getOperatingSystemName() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT);
    }

    private static OperatingSystem getOperatingSystem() {
        String name = RenderDocLoader.getOperatingSystemName();
        if (name.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (name.contains("mac")) {
            return OperatingSystem.OSX;
        }
        if (name.contains("solaris")) {
            return OperatingSystem.SOLARIS;
        }
        if (name.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        if (name.contains("linux")) {
            return OperatingSystem.LINUX;
        }
        return name.contains("unix") ? OperatingSystem.LINUX : OperatingSystem.UNKNOWN;
    }

    public static void install() {
        block4: {
            OperatingSystem os = RenderDocLoader.getOperatingSystem();
            BetterCloudsStatic.getDataDirectory().toFile().mkdirs();
            try {
                if (os == OperatingSystem.WINDOWS) {
                    RenderDocLoader.downloadWindows();
                    break block4;
                }
                if (os == OperatingSystem.LINUX) {
                    RenderDocLoader.downloadLinux();
                    break block4;
                }
                throw new RuntimeException("Unsupported OS: " + RenderDocLoader.getOperatingSystemName());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static void uninstall() {
        if (!Files.exists(RenderDocLoader.libPath(), new LinkOption[0])) {
            return;
        }
        if (RenderDoc.isAvailable()) {
            throw new RuntimeException("Cannot uninstall RenderDoc as it is currently in use");
        }
        try {
            Files.delete(RenderDocLoader.libPath());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean isAvailable() {
        OperatingSystem os = RenderDocLoader.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS) {
            return RenderDocLoader.isAvailable("renderdoc.dll", "913a2f5b87981169f40207ab81be3e88");
        }
        if (os == OperatingSystem.LINUX) {
            return RenderDocLoader.isAvailable("librenderdoc.so", "3d134559f0128b2e079eab0bd5395588");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAvailable(String name, String md5sum) {
        File dllFile = BetterCloudsStatic.getDataDirectory().resolve(name).toFile();
        if (!dllFile.exists()) return false;
        if (dllFile.isDirectory()) {
            return false;
        }
        try (FileInputStream is = new FileInputStream(dllFile);){
            String sum = DigestUtils.md5Hex((InputStream)is);
            if (sum.equalsIgnoreCase(md5sum)) {
                boolean bl = true;
                return bl;
            }
            RenderDoc.LOGGER.warn("renderdoc library present but md5 checksum wrong: {}, expected {}", sum, md5sum);
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadWindows() throws IOException {
        File archive = BetterCloudsStatic.getDataDirectory().resolve("RenderDoc_1.30_64.zip").toFile();
        FileUtils.copyURLToFile((URL)new URL("https://renderdoc.org/stable/1.30/RenderDoc_1.30_64.zip"), (File)archive);
        try (ZipFile zipFile = new ZipFile(archive);){
            InputStream dllEntry = zipFile.getInputStream(zipFile.getEntry("RenderDoc_1.30_64/renderdoc.dll"));
            File dllFile = LIB_WINDOWS_PATH.toFile();
            FileUtils.copyInputStreamToFile((InputStream)dllEntry, (File)dllFile);
        }
        finally {
            archive.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadLinux() throws IOException {
        File archive = BetterCloudsStatic.getDataDirectory().resolve("renderdoc_1.30.tar.gz").toFile();
        FileUtils.copyURLToFile((URL)new URL("https://renderdoc.org/stable/1.30/renderdoc_1.30.tar.gz"), (File)archive);
        try (FileInputStream source = new FileInputStream(archive);
             GZIPInputStream gzip = new GZIPInputStream(source);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);){
            TarArchiveEntry entry;
            File dllFile = LIB_LINUX_PATH.toFile();
            boolean found = false;
            while ((entry = tar.getNextTarEntry()) != null) {
                String name = entry.getName();
                if (!name.equalsIgnoreCase("renderdoc_1.30/lib/librenderdoc.so")) continue;
                FileUtils.copyInputStreamToFile((InputStream)tar, (File)dllFile);
                found = true;
                break;
            }
            if (!found) {
                throw new FileNotFoundException("renderdoc_1.30/lib/librenderdoc.so");
            }
        }
        finally {
            archive.delete();
        }
    }

    public static void load() {
        if (RenderDoc.isAvailable()) {
            return;
        }
        OperatingSystem os = RenderDocLoader.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS || os == OperatingSystem.LINUX) {
            try {
                RenderDocLibrary renderdocLibrary;
                String libPath = RenderDocLoader.libPath().toAbsolutePath().toString();
                if (os == OperatingSystem.WINDOWS) {
                    renderdocLibrary = (RenderDocLibrary)Native.load((String)libPath, RenderDocLibrary.class);
                } else {
                    int flags = 6;
                    if (DynamicLinkLoader.dlopen((CharSequence)libPath, (int)flags) == 0L) {
                        throw new UnsatisfiedLinkError();
                    }
                    renderdocLibrary = (RenderDocLibrary)Native.load((String)libPath, RenderDocLibrary.class, Map.of("open-flags", flags));
                }
                RenderDoc.init(renderdocLibrary);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    public static Path libPath() {
        OperatingSystem os = RenderDocLoader.getOperatingSystem();
        if (os == OperatingSystem.WINDOWS) {
            return LIB_WINDOWS_PATH;
        }
        if (os == OperatingSystem.LINUX) {
            return LIB_LINUX_PATH;
        }
        throw new RuntimeException("Unsupported OS: " + RenderDocLoader.getOperatingSystemName());
    }

    private static enum OperatingSystem {
        UNKNOWN,
        LINUX,
        SOLARIS,
        WINDOWS,
        OSX;

    }
}

