/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3532;
import org.lwjgl.opengl.GL33;

public class PerfTimer
implements AutoCloseable {
    private int query;
    private int queryWaiting;
    private boolean first = true;
    private int frameCount = 0;
    private List<Double> gpu = new ArrayList<Double>();
    private List<Double> cpu = new ArrayList<Double>();
    private long startTime;

    public PerfTimer() {
        this.query = GL33.glGenQueries();
        this.queryWaiting = GL33.glGenQueries();
    }

    public void start() {
        GL33.glFinish();
        GL33.glBeginQuery((int)35007, (int)this.query);
        this.startTime = System.nanoTime();
    }

    public void stop() {
        GL33.glEndQuery((int)35007);
        int done = this.queryWaiting;
        this.queryWaiting = this.query;
        this.query = done;
        if (this.first) {
            this.first = false;
            return;
        }
        long ns = GL33.glGetQueryObjectui64((int)done, (int)34918);
        this.gpu.add((double)ns / 1000000.0);
        ns = System.nanoTime() - this.startTime;
        this.cpu.add((double)ns / 1000000.0);
        ++this.frameCount;
        GL33.glFinish();
    }

    public List<Double> gpu() {
        return this.gpu;
    }

    public List<Double> cpu() {
        return this.cpu;
    }

    public int frames() {
        return this.frameCount;
    }

    public void reset() {
        if (!this.gpu.isEmpty()) {
            this.gpu = new ArrayList<Double>();
        }
        if (!this.cpu.isEmpty()) {
            this.cpu = new ArrayList<Double>();
        }
        this.frameCount = 0;
    }

    @Override
    public void close() {
        GL33.glDeleteQueries((int[])new int[]{this.query, this.queryWaiting});
    }

    public record Stats(double min, double max, double mean, double sd, double q25, double median, double q75) {
        public static Stats of(List<Double> times) {
            times.sort(Double::compare);
            double median = times.get(times.size() / 2);
            double q25 = times.get((int)Math.ceil((double)times.size() * 0.25));
            double q75 = times.get((int)Math.ceil((double)times.size() * 0.75));
            double min = times.get(0);
            double max = times.get(times.size() - 1);
            double mean = times.stream().mapToDouble(d -> d).average().orElse(0.0);
            double variance = times.stream().mapToDouble(d -> class_3532.method_33723((double)(d - mean))).sum() / (double)(times.size() - 1);
            if (times.size() == 1) {
                variance = 0.0;
            }
            double stdDev = Math.sqrt(variance);
            return new Stats(min, max, mean, stdDev, q25, median, q75);
        }

        public String formatted() {
            return String.format("  %.3f | %.3f \u00a77min, max\u00a7r\n  %.3f | %.3f \u00a77mean, sd\u00a7r\n  %.3f | %.3f | %.3f \u00a77q25, med, q75\u00a7r", this.min, this.max, this.mean, this.sd, this.q25, this.median, this.q75);
        }

        @Override
        public String toString() {
            return String.format("min, max:      \t%.3f | %.3f\nmean, sd:      \t%.3f | %.3f\nq25, med, q75: \t%.3f | %.3f | %.3f", this.min, this.max, this.mean, this.sd, this.q25, this.median, this.q75);
        }
    }
}

