/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.mixin.optional.ExtendedShaderCoderbotAccessor;
import com.qendolin.betterclouds.mixin.optional.FallbackShaderCoderbotAccessor;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ExtendedShader;
import net.coderbot.iris.pipeline.newshader.NewWorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.ShaderKey;
import net.coderbot.iris.pipeline.newshader.fallback.FallbackShader;
import net.minecraft.class_5944;

public class IrisCoderbotCompatImpl
extends IrisCompat {
    private static final String INCOMPATIBLE_ERROR = "Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: ";

    @Override
    public boolean isShadersEnabled() {
        return Iris.getIrisConfig().areShadersEnabled() && Iris.getCurrentPack().isPresent();
    }

    @Override
    public boolean isFrustumCullingDisabled() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline == null) {
            return false;
        }
        return pipeline.shouldDisableFrustumCulling();
    }

    @Override
    public void bindFramebuffer() {
        GlFramebuffer after;
        GlFramebuffer before;
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (!(pipeline instanceof NewWorldRenderingPipeline)) {
            return;
        }
        NewWorldRenderingPipeline corePipeline = (NewWorldRenderingPipeline)pipeline;
        class_5944 program = corePipeline.getShaderMap().getShader(ShaderKey.CLOUDS);
        if (program instanceof ExtendedShader) {
            ExtendedShader extended = (ExtendedShader)program;
            ExtendedShaderCoderbotAccessor access = (ExtendedShaderCoderbotAccessor)extended;
            before = access.getWritingToBeforeTranslucent();
            after = access.getWritingToAfterTranslucent();
        } else if (program instanceof FallbackShader) {
            FallbackShader fallback = (FallbackShader)program;
            FallbackShaderCoderbotAccessor access = (FallbackShaderCoderbotAccessor)fallback;
            before = access.getWritingToBeforeTranslucent();
            after = access.getWritingToAfterTranslucent();
        } else {
            throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Shader is of type " + String.valueOf(program.getClass()) + ", Iris Version: " + Iris.getVersion());
        }
        GlFramebuffer required = corePipeline.isBeforeTranslucent ? before : after;
        if (required == null) {
            throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Required framebuffer is null, Iris Version: " + Iris.getVersion());
        }
        if (corePipeline.isBeforeTranslucent) {
            before.bindAsDrawBuffer();
        } else {
            after.bindAsDrawBuffer();
        }
    }
}

