/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.IrisCoderbotCompatImpl;
import com.qendolin.betterclouds.compat.IrisCompatImpl;
import com.qendolin.betterclouds.compat.ModLoaded;

public abstract class IrisCompat {
    private static IrisCompat instance;
    private static boolean isActive;

    public static void initialize() {
        block12: {
            if (instance != null) {
                return;
            }
            if (!ModLoaded.IRIS) {
                BetterCloudsStatic.getLogger().info("Iris: not loaded");
                instance = new Stub();
                return;
            }
            BetterCloudsStatic.getLogger().info("Iris: initializing compat");
            boolean coderbotPackage = false;
            try {
                Class.forName("net.coderbot.iris.Iris");
                coderbotPackage = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            boolean irisshadersPackage = false;
            try {
                Class.forName("net.irisshaders.iris.Iris");
                irisshadersPackage = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (irisshadersPackage) {
                    instance = new IrisCompatImpl();
                    break block12;
                }
                if (coderbotPackage) {
                    BetterCloudsStatic.getLogger().info("Using old net.coderbot.iris package");
                    instance = new IrisCoderbotCompatImpl();
                    break block12;
                }
                throw new RuntimeException("Neither net.coderbot.iris nor net.irisshaders.iris packages found");
            }
            catch (Throwable e) {
                BetterCloudsStatic.getLogger().error("Iris version not compatible", e);
            }
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static IrisCompat instance() {
        return instance;
    }

    public abstract boolean isShadersEnabled();

    public abstract boolean isFrustumCullingDisabled();

    public abstract void bindFramebuffer();

    static {
        isActive = false;
    }

    private static class Stub
    extends IrisCompat {
        private Stub() {
        }

        @Override
        public boolean isShadersEnabled() {
            return false;
        }

        @Override
        public boolean isFrustumCullingDisabled() {
            return false;
        }

        @Override
        public void bindFramebuffer() {
        }
    }
}

