/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.compat.ModLoaded;
import com.qendolin.betterclouds.compat.SereneSeasonsCompatImpl;
import com.qendolin.betterclouds.config.SereneSeasonsConfig;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.class_1937;

public abstract class SereneSeasonsCompat {
    public static final Map<String, Function<SereneSeasonsConfig, Float>> SUB_SEASON_CLOUDINESS_LOOKUP = Map.ofEntries(Map.entry("early_spring", config -> Float.valueOf(config.earlySpringCloudiness)), Map.entry("mid_spring", config -> Float.valueOf(config.midSpringCloudiness)), Map.entry("late_spring", config -> Float.valueOf(config.lateSpringCloudiness)), Map.entry("early_summer", config -> Float.valueOf(config.earlySummerCloudiness)), Map.entry("mid_summer", config -> Float.valueOf(config.midSummerCloudiness)), Map.entry("late_summer", config -> Float.valueOf(config.lateSummerCloudiness)), Map.entry("early_autumn", config -> Float.valueOf(config.earlyAutumnCloudiness)), Map.entry("mid_autumn", config -> Float.valueOf(config.midAutumnCloudiness)), Map.entry("late_autumn", config -> Float.valueOf(config.lateAutumnCloudiness)), Map.entry("early_winter", config -> Float.valueOf(config.earlyWinterCloudiness)), Map.entry("mid_winter", config -> Float.valueOf(config.midWinterCloudiness)), Map.entry("late_winter", config -> Float.valueOf(config.lateWinterCloudiness)));
    private static final AtomicBoolean initialized = new AtomicBoolean(false);
    private static SereneSeasonsCompat instance;
    private static boolean isActive;

    public static void initialize() {
        if (initialized.getAndSet(true)) {
            return;
        }
        if (!ModLoaded.SERENE_SEASONS) {
            BetterCloudsStatic.getLogger().info("SereneSeasons: not loaded");
            instance = new Stub();
            return;
        }
        BetterCloudsStatic.getLogger().info("SereneSeasons: initializing compat");
        try {
            instance = new SereneSeasonsCompatImpl();
        }
        catch (Throwable e) {
            BetterCloudsStatic.getLogger().error("SereneSeasons version not compatible", e);
        }
        if (instance == null) {
            instance = new Stub();
        } else {
            isActive = true;
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public static SereneSeasonsCompat instance() {
        return instance;
    }

    public abstract float getCloudinessFactor(class_1937 var1);

    static {
        isActive = false;
    }

    private static class Stub
    extends SereneSeasonsCompat {
        private Stub() {
        }

        @Override
        public float getCloudinessFactor(class_1937 world) {
            return 1.0f;
        }

        static {
            instance = new Stub();
        }
    }
}

