/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.platform.fabric;

import com.qendolin.betterclouds.platform.ModVersion;
import java.util.Optional;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public class ModVersionImpl
extends ModVersion {
    private final Version delegate;

    public ModVersionImpl(Version delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isPresent() {
        return this.delegate != null;
    }

    @Override
    public String getFriendlyString() {
        return this.delegate.getFriendlyString();
    }

    @Override
    public Optional<ModVersion.SemVer> asSemVer() {
        SemanticVersion semver;
        if (this.delegate instanceof SemanticVersion) {
            semver = (SemanticVersion)this.delegate;
        } else {
            try {
                semver = SemanticVersion.parse((String)this.delegate.getFriendlyString());
            }
            catch (VersionParsingException e) {
                return Optional.empty();
            }
        }
        int major = 0;
        int minor = 0;
        int patch = 0;
        int count = semver.getVersionComponentCount();
        if (count == 0) {
            return Optional.empty();
        }
        if (count >= 1) {
            major = semver.getVersionComponent(0);
        }
        if (count >= 2) {
            minor = semver.getVersionComponent(1);
        }
        if (count >= 3) {
            patch = semver.getVersionComponent(2);
        }
        return Optional.of(new ModVersion.SemVer(major, minor, patch, semver.getBuildKey().orElse(""), semver.getPrereleaseKey().orElse("")));
    }
}

