/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.test;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.platform.EventHooks;
import com.qendolin.betterclouds.test.GameTestEnabled;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4063;
import net.minecraft.class_424;
import net.minecraft.class_437;

public class GameTest {
    private static final AtomicReference<Throwable> caught = new AtomicReference();
    private static final AtomicBoolean finished = new AtomicBoolean();

    public static void onClientExit() {
        if (!GameTestEnabled.ENABLED) {
            return;
        }
        if (caught.get() != null || !finished.get()) {
            BetterCloudsStatic.getLogger().error("\n========================\n    GameTest failed!    \n========================");
            if (caught.get() != null) {
                throw new RuntimeException(caught.get());
            }
            if (!finished.get()) {
                throw new RuntimeException("Test did not finish!");
            }
        } else {
            BetterCloudsStatic.getLogger().info("\n========================\n    GameTest passed!    \n========================");
        }
    }

    public static void run(class_310 client) {
        if (!GameTestEnabled.ENABLED) {
            return;
        }
        AtomicBoolean stop = new AtomicBoolean(false);
        TestContext ctx = new TestContext(client);
        EventHooks.instance.onClientTick(c -> {
            if (stop.get()) {
                if (c.method_22108()) {
                    c.method_1592();
                }
                return;
            }
            ctx.lock.lock();
            try {
                ctx.tick.signalAll();
            }
            finally {
                ctx.lock.unlock();
            }
        });
        Thread timeoutThread = new Thread(() -> {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException ignored) {
                return;
            }
            if (!finished.get()) {
                caught.set(new RuntimeException("GameTest timed out!"));
                stop.set(true);
            }
        });
        Thread testThread = new Thread(() -> {
            try {
                GameTest.runTestAsync(ctx);
                finished.set(true);
            }
            catch (Throwable e) {
                caught.set(e);
            }
            finally {
                stop.set(true);
            }
        });
        timeoutThread.start();
        testThread.setName("Test thread");
        testThread.setDaemon(true);
        testThread.start();
    }

    private static void runTestAsync(TestContext test) {
        test.waitFor(client -> client.method_18506() == null, 1200L);
        test.runOnClient(client -> {
            client.field_1690.method_42528().method_41748((Object)class_4063.field_18164);
            boolean exists = client.method_1586().method_230("Game Test");
            if (!exists) {
                throw new RuntimeException("No world 'Game Test', please create it");
            }
            client.method_41735().method_41894(null, "Game Test");
        });
        test.waitFor(client -> client.field_1687 != null && client.method_1576() != null && client.method_1576().method_3806(), 1200L);
        test.waitFor(client -> client.field_1755 == null, 1200L);
        test.waitTicks(20);
        test.runOnClient(client -> {
            assert (client.field_1687 != null);
            client.field_1687.method_8525();
            client.method_18096((class_437)new class_424((class_2561)class_2561.method_43471((String)"menu.savingLevel")));
        });
        test.waitFor(client -> (client.method_1576() == null || client.method_1576().method_3806()) && client.field_1687 == null, 1200L);
    }

    private static class TestContext {
        private final Lock lock = new ReentrantLock();
        private final Condition tick = this.lock.newCondition();
        private final class_310 client;

        private TestContext(class_310 client) {
            this.client = client;
        }

        public void runOnClient(Consumer<class_310> consumer) {
            Semaphore semaphore = new Semaphore(0);
            AtomicReference caught = new AtomicReference();
            this.client.execute(() -> {
                try {
                    consumer.accept(this.client);
                }
                catch (Throwable e) {
                    caught.set(e);
                }
                finally {
                    semaphore.release();
                }
            });
            semaphore.acquireUninterruptibly();
            if (caught.get() != null) {
                throw new RuntimeException((Throwable)caught.get());
            }
        }

        public void waitFor(Predicate<class_310> consumer, long timeout) {
            while (!consumer.test(this.client)) {
                this.waitTick();
                if (--timeout <= 0L) {
                    throw new AssertionError((Object)"Timed out waiting for predicate");
                }
            }
        }

        public void waitTicks(int ticks) {
            for (int i = 0; i < ticks; ++i) {
                this.waitTick();
            }
        }

        public void waitTick() {
            this.lock.lock();
            try {
                this.tick.awaitUninterruptibly();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

