/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.config.Config;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;

public class VanillaRenderTarget {
    private final Minecraft client;
    private static final Supplier<String> RENDER_PASS_LABEL = () -> "BetterClouds";
    private final boolean useIris;
    private RenderPass renderPass = null;

    public VanillaRenderTarget(Minecraft client, Config config) {
        this.client = client;
        this.useIris = IrisCompat.instance().isShadersEnabled() && config.useIrisFBO;
    }

    public void begin() {
        if (this.useIris) {
            IrisCompat.instance().bindFramebuffer();
            return;
        }
        RenderTarget framebuffer = this.client.levelRenderer.getCloudsTarget();
        if (framebuffer == null) {
            framebuffer = this.client.getMainRenderTarget();
        }
        this.renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(RENDER_PASS_LABEL, framebuffer.getColorTextureView(), OptionalInt.empty(), framebuffer.getDepthTextureView(), OptionalDouble.empty());
    }

    public void end() {
        if (this.useIris) {
            return;
        }
        if (this.renderPass != null) {
            this.renderPass.close();
        }
    }
}

