/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.qendolin.betterclouds.duck.CustomCategoryTabDuck;
import com.qendolin.betterclouds.gui.CustomScrollableNavigationBar;
import com.qendolin.betterclouds.telemetry.IssueReportManager;
import dev.isxander.yacl3.api.PlaceholderCategory;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.utils.OptionUtils;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends YACLScreen {
    public ConfigScreen(YetAnotherConfigLib config, Screen parent) {
        super(config, parent);
    }

    protected void init() {
        int currentTab;
        assert (this.minecraft != null);
        this.tabArea = new ScreenRectangle(0, 24, this.width, this.height - 24);
        int n = currentTab = this.tabNavigationBar != null ? this.tabNavigationBar.getTabs().indexOf((Object)this.tabManager.getCurrentTab()) : 0;
        if (currentTab == -1) {
            currentTab = 0;
        }
        this.tabNavigationBar = new CustomScrollableNavigationBar(this.width, this.tabManager, this.config.categories().stream().map(category -> {
            if (category instanceof PlaceholderCategory) {
                PlaceholderCategory placeholder = (PlaceholderCategory)category;
                return new YACLScreen.PlaceholderTab(placeholder, (YACLScreen)this);
            }
            YACLScreen.CategoryTab tab = new YACLScreen.CategoryTab((YACLScreen)this, category, this.tabArea);
            ((CustomCategoryTabDuck)tab).betterclouds$applyOverride();
            return tab;
        }).toList());
        this.tabNavigationBar.selectTab(currentTab, false);
        this.tabNavigationBar.arrangeElements();
        this.tabManager.setTabArea(this.tabArea);
        this.addRenderableWidget((GuiEventListener)this.tabNavigationBar);
        this.config.initConsumer().accept(this);
    }

    public boolean pendingChanges() {
        AtomicBoolean pendingChanges = new AtomicBoolean(false);
        OptionUtils.consumeOptions((YetAnotherConfigLib)this.config, option -> {
            if (option.changed()) {
                pendingChanges.set(true);
                return true;
            }
            return false;
        });
        return pendingChanges.get();
    }

    public void tick() {
        try {
            super.tick();
        }
        catch (Exception e) {
            if (!IssueReportManager.handle(e, "An error occurred while processing the config screen: " + e.getMessage())) {
                throw e;
            }
            assert (this.minecraft != null);
            this.minecraft.execute(() -> this.minecraft.setScreen(IssueReportManager.popQueuedScreen()));
        }
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.minecraft == null || this.minecraft.level == null) {
            this.renderPanorama(context, delta);
            this.renderBlurredBackground(context);
        }
        this.renderMenuBackground(context);
    }

    public void renderTransparentBackground(GuiGraphics context) {
        this.renderMenuBackground(context);
    }

    protected void renderMenuBackground(GuiGraphics context) {
        if (this.tabArea == null) {
            return;
        }
        context.fill(this.width / 3 * 2 + 1, this.tabArea.top(), this.width, this.tabArea.bottom(), 0x6B000000);
    }

    public void finishOrSave() {
        this.onClose();
    }

    public void onClose() {
        this.config.saveFunction().run();
        super.onClose();
    }

    public static class HiddenScreen
    extends Screen {
        private final Button showButton;

        public HiddenScreen(Component title, Button showButton) {
            super(title);
            this.showButton = showButton;
            this.addRenderableWidget((GuiEventListener)showButton);
        }

        public boolean shouldCloseOnEsc() {
            return false;
        }

        public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        }

        public void renderTransparentBackground(GuiGraphics context) {
        }

        protected void renderMenuBackground(GuiGraphics context) {
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.showButton;
        }
    }
}

