/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.config;

import com.qendolin.betterclouds.config.Config;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.config.DimensionsGUI;
import com.qendolin.betterclouds.config.FabricSeasonsGUI;
import com.qendolin.betterclouds.config.SereneSeasonsGUI;
import com.qendolin.betterclouds.config.ShaderPresetGUI;
import com.qendolin.betterclouds.gui.ConfigScreen;
import com.qendolin.betterclouds.gui.OptionGroupBuilderWrapper;
import com.qendolin.betterclouds.gui.YACLOptionBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import dev.isxander.yacl3.gui.controllers.TickBoxController;
import dev.isxander.yacl3.gui.controllers.slider.FloatSliderController;
import dev.isxander.yacl3.gui.controllers.slider.IntegerSliderController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;

public class ConfigGUI {
    private final Config config;
    public final ShaderPresetGUI shaderPresetGUI;
    public final SereneSeasonsGUI sereneSeasonsCompatGUI;
    public final FabricSeasonsGUI fabricSeasonsCompatGUI;
    public final DimensionsGUI dimensionsGUI;
    public final Option<Integer> chunkSize;
    public final Option<Float> distance;
    public final Option<Float> fuzziness;
    public final Option<Float> spacing;
    public final Option<Float> sparsity;
    public final Option<Boolean> shuffle;
    public final Option<Float> randomPlacement;
    public final Option<Float> yRange;
    public final Option<Float> yOffset;
    public final Option<Float> samplingScale;
    public final Option<Float> sizeXZ;
    public final Option<Float> sizeY;
    public final Option<Float> scaleFalloffMin;
    public final Option<Float> travelSpeed;
    public final Option<Float> windEffectFactor;
    public final Option<Float> windSpeedFactor;
    public final Option<Float> colorVariationFactor;
    public final Option<Boolean> celestialBodyHalo;
    public final Option<Boolean> enabled;
    public final Option<Float> fogRangeFactor;
    public final Option<Float> fogEndFactor;
    public final Option<Boolean> usePersistentBuffers;
    public final Option<Boolean> useFrustumCulling;
    public final List<Tuple<ConfigCategory.Builder, List<Tuple<OptionGroup.Builder, List<Option<?>>>>>> categories = new ArrayList();
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> commonCategory = new ArrayList();
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> generationCategory = new ArrayList();
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> appearanceCategory = new ArrayList();
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> performanceCategory = new ArrayList();
    public final List<Tuple<OptionGroup.Builder, List<Option<?>>>> compatCategory = new ArrayList();
    public final List<Option<?>> commonPresetsGroup = new ArrayList();
    public final List<Option<?>> commonGenerationGroup = new ArrayList();
    public final List<Option<?>> commonAppearanceGroup = new ArrayList();
    public final List<Option<?>> generationVisualGroup = new ArrayList();
    public final List<Option<?>> generationPerformanceGroup = new ArrayList();
    public final List<Option<?>> appearanceGeometryGroup = new ArrayList();
    public final List<Option<?>> appearanceVisibilityGroup = new ArrayList();
    public final List<Option<?>> appearanceColorGroup = new ArrayList();
    public final List<Option<?>> appearanceSkyGroup = new ArrayList();
    public final List<Option<?>> performanceGenerationGroup = new ArrayList();
    public final List<Option<?>> performanceTechnicalGroup = new ArrayList();
    public static final String LANG_KEY_PREFIX = "betterclouds.config";

    public ConfigGUI(Config defaults, Config config) {
        this.config = config;
        this.shaderPresetGUI = new ShaderPresetGUI(defaults, config);
        this.sereneSeasonsCompatGUI = new SereneSeasonsGUI(defaults.sereneSeasonsConfig, config.sereneSeasonsConfig);
        this.fabricSeasonsCompatGUI = new FabricSeasonsGUI(defaults.fabricSeasonsConfig, config.fabricSeasonsConfig);
        this.dimensionsGUI = new DimensionsGUI(defaults, config);
        this.chunkSize = ConfigGUI.createOption(Integer.TYPE, "chunkSize").binding(defaults.chunkSize, () -> config.chunkSize, val -> {
            config.chunkSize = val;
        }).customController(opt -> new IntegerSliderController(opt, 16, 128, 8)).build();
        this.distance = ConfigGUI.createOption(Float.TYPE, "distance").binding(Float.valueOf(defaults.distance), () -> Float.valueOf(config.distance), val -> {
            config.distance = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 1.0f, 4.0f, 0.05f, ConfigGUI::formatAsTimes)).build();
        this.fuzziness = ConfigGUI.createOption(Float.TYPE, "fuzziness").binding(Float.valueOf(defaults.fuzziness), () -> Float.valueOf(config.fuzziness), val -> {
            config.fuzziness = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.spacing = ConfigGUI.createOption(Float.TYPE, "spacing").binding(Float.valueOf(defaults.spacing), () -> Float.valueOf(config.spacing), val -> {
            config.spacing = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 2.0f, 64.0f, 0.25f)).build();
        this.sparsity = ConfigGUI.createOption(Float.TYPE, "sparsity").binding(Float.valueOf(defaults.sparsity), () -> Float.valueOf(config.sparsity), val -> {
            config.sparsity = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.shuffle = ConfigGUI.createOption(Boolean.TYPE, "shuffle").binding(defaults.shuffle, () -> config.shuffle, val -> {
            config.shuffle = val;
        }).customController(TickBoxController::new).build();
        this.randomPlacement = ConfigGUI.createOption(Float.TYPE, "randomPlacement").binding(Float.valueOf(defaults.randomPlacement), () -> Float.valueOf(config.randomPlacement), val -> {
            config.randomPlacement = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.01f, ConfigGUI::formatAsPercent)).build();
        this.yRange = ConfigGUI.createOption(Float.TYPE, "yRange").binding(Float.valueOf(defaults.yRange), () -> Float.valueOf(config.yRange), val -> {
            config.yRange = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 265.0f, 1.0f)).build();
        this.yOffset = ConfigGUI.createOption(Float.TYPE, "yOffset").binding(Float.valueOf(defaults.yOffset), () -> Float.valueOf(config.yOffset), val -> {
            config.yOffset = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, -384.0f, 256.0f, 8.0f)).build();
        this.samplingScale = ConfigGUI.createOption(Float.TYPE, "samplingScale").binding(Float.valueOf(defaults.samplingScale), () -> Float.valueOf(config.samplingScale), val -> {
            config.samplingScale = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.25f, 4.0f, 0.01f, ConfigGUI::formatAsTimes)).build();
        this.sizeXZ = ConfigGUI.createOption(Float.TYPE, "sizeXZ").binding(Float.valueOf(defaults.sizeXZ), () -> Float.valueOf(config.sizeXZ), val -> {
            config.sizeXZ = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 2.0f, 64.0f, 1.0f)).build();
        this.sizeY = ConfigGUI.createOption(Float.TYPE, "sizeY").binding(Float.valueOf(defaults.sizeY), () -> Float.valueOf(config.sizeY), val -> {
            config.sizeY = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 32.0f, 1.0f)).build();
        this.scaleFalloffMin = ConfigGUI.createOption(Float.TYPE, "scaleFalloffMin").binding(Float.valueOf(defaults.scaleFalloffMin), () -> Float.valueOf(config.scaleFalloffMin), val -> {
            config.scaleFalloffMin = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.travelSpeed = ConfigGUI.createOption(Float.TYPE, "travelSpeed").binding(Float.valueOf(defaults.travelSpeed), () -> Float.valueOf(config.travelSpeed), val -> {
            config.travelSpeed = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 0.4f, 0.005f, ConfigGUI::formatAsBlocksPerSecond)).build();
        this.windEffectFactor = ConfigGUI.createOption(Float.TYPE, "windEffectFactor").binding(Float.valueOf(defaults.windEffectFactor), () -> Float.valueOf(config.windEffectFactor), val -> {
            config.windEffectFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.windSpeedFactor = ConfigGUI.createOption(Float.TYPE, "windSpeedFactor").binding(Float.valueOf(defaults.windSpeedFactor), () -> Float.valueOf(config.windSpeedFactor), val -> {
            config.windSpeedFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.colorVariationFactor = ConfigGUI.createOption(Float.TYPE, "colorVariationFactor").binding(Float.valueOf(defaults.colorVariationFactor), () -> Float.valueOf(config.colorVariationFactor), val -> {
            config.colorVariationFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.0f, 1.0f, 0.05f, ConfigGUI::formatAsPercent)).build();
        this.celestialBodyHalo = ConfigGUI.createOption(Boolean.TYPE, "celestialBodyHalo").binding(defaults.celestialBodyHalo, () -> config.celestialBodyHalo, val -> {
            config.celestialBodyHalo = val;
        }).customController(TickBoxController::new).build();
        this.enabled = ConfigGUI.createOption(Boolean.TYPE, "enabled").binding(defaults.enabled, () -> config.enabled, val -> {
            config.enabled = val;
        }).customController(opt -> new BooleanController(opt, val -> Component.translatable((String)("betterclouds.config.entry.enabled." + val)), false)).build();
        this.fogRangeFactor = ConfigGUI.createOption(Float.TYPE, "fogRangeFactor").binding(Float.valueOf(defaults.fogRangeFactor), () -> Float.valueOf(config.fogRangeFactor), val -> {
            config.fogRangeFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.1f, 8.0f, 0.1f, ConfigGUI::formatAsTimes)).build();
        this.fogEndFactor = ConfigGUI.createOption(Float.TYPE, "fogEndFactor").binding(Float.valueOf(defaults.fogEndFactor), () -> Float.valueOf(config.fogEndFactor), val -> {
            config.fogEndFactor = val.floatValue();
        }).customController(opt -> new FloatSliderController(opt, 0.5f, 16.0f, 0.1f, ConfigGUI::formatAsTimes)).build();
        this.usePersistentBuffers = ConfigGUI.createOption(Boolean.TYPE, "usePersistentBuffers").binding(defaults.usePersistentBuffers, () -> config.usePersistentBuffers, val -> {
            config.usePersistentBuffers = val;
        }).customController(TickBoxController::new).build();
        this.useFrustumCulling = ConfigGUI.createOption(Boolean.TYPE, "useFrustumCulling").binding(defaults.useFrustumCulling, () -> config.useFrustumCulling, val -> {
            config.useFrustumCulling = val;
        }).customController(TickBoxController::new).build();
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("common")), this.commonCategory));
        this.commonCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.appearance")), this.commonAppearanceGroup));
        this.commonAppearanceGroup.addAll(List.of(this.enabled, this.shaderPresetGUI.opacity, this.shaderPresetGUI.opacityFactor));
        this.commonCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.presets")), this.commonPresetsGroup));
        this.commonPresetsGroup.addAll(List.of(this.shaderPresetGUI.selectedPreset, this.shaderPresetGUI.presetTitle, this.shaderPresetGUI.copyPresetButton, this.shaderPresetGUI.removePresetButton));
        this.commonCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.generation")), this.commonGenerationGroup));
        this.commonGenerationGroup.addAll(List.of(this.sizeXZ, this.sizeY, this.spacing, this.samplingScale, this.distance));
        this.commonCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("common.shaders")), this.shaderPresetGUI.commonShadersGroup));
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("generation")), this.generationCategory));
        this.generationCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("generation.visual")), this.generationVisualGroup));
        this.generationVisualGroup.addAll(List.of(this.randomPlacement, this.fuzziness, this.sparsity, this.yRange, this.yOffset, this.spacing, this.samplingScale, this.shuffle));
        this.generationCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("generation.performance")), this.generationPerformanceGroup));
        this.generationPerformanceGroup.addAll(List.of(this.distance, this.chunkSize));
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("appearance")), this.appearanceCategory));
        this.appearanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.geometry")), this.appearanceGeometryGroup));
        this.appearanceGeometryGroup.addAll(List.of(this.sizeXZ, this.sizeY, this.scaleFalloffMin, this.travelSpeed, this.windEffectFactor, this.windSpeedFactor));
        this.appearanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.visibility")), this.appearanceVisibilityGroup));
        this.appearanceVisibilityGroup.addAll(List.of(this.enabled, this.shaderPresetGUI.opacity, this.shaderPresetGUI.opacityFactor, this.shaderPresetGUI.opacityExponent, this.fogRangeFactor, this.fogEndFactor));
        this.appearanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.color")), this.appearanceColorGroup));
        this.appearanceColorGroup.addAll(List.of(this.colorVariationFactor, this.shaderPresetGUI.gamma, this.shaderPresetGUI.dayBrightness, this.shaderPresetGUI.nightBrightness, this.shaderPresetGUI.saturation, this.shaderPresetGUI.tint));
        this.appearanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("appearance.sky")), this.appearanceSkyGroup));
        this.appearanceSkyGroup.add(this.celestialBodyHalo);
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("performance")), this.performanceCategory));
        this.performanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("performance.generation")), this.performanceGenerationGroup));
        this.performanceGenerationGroup.addAll(List.of(this.spacing, this.chunkSize, this.distance, this.sparsity, this.fuzziness, this.shuffle));
        this.performanceCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("performance.technical")), this.performanceTechnicalGroup));
        this.performanceTechnicalGroup.addAll(List.of(this.usePersistentBuffers, this.useFrustumCulling));
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("shaders")), this.shaderPresetGUI.shadersCategory));
        this.categories.add(new Tuple((Object)ConfigCategory.createBuilder().name(ConfigGUI.categoryLabel("compat")), this.compatCategory));
        this.compatCategory.add(new Tuple((Object)new OptionGroupBuilderWrapper(this.dimensionsGUI.compatDimensionsListGroup), List.of()));
        this.compatCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("compat.sereneSeasons")).description(OptionDescription.of((Component[])new Component[]{ConfigGUI.groupDescription("compat.sereneSeasons")})).collapsed(true), this.sereneSeasonsCompatGUI.compatSereneSeasonsGroup));
        this.compatCategory.add(new Tuple((Object)OptionGroup.createBuilder().name(ConfigGUI.groupLabel("compat.fabricSeasons")).description(OptionDescription.of((Component[])new Component[]{ConfigGUI.groupDescription("compat.fabricSeasons")})).collapsed(true), this.fabricSeasonsCompatGUI.compatFabricSeasonsGroup));
    }

    public static ConfigScreen create(Screen parent) {
        YetAnotherConfigLib yacl = YetAnotherConfigLib.create(ConfigManager.handler(), (defaults, config, builder) -> new ConfigGUI((Config)defaults, (Config)config).assemble(builder));
        return new ConfigScreen(yacl, parent);
    }

    public YetAnotherConfigLib.Builder assemble(YetAnotherConfigLib.Builder builder) {
        builder = builder.save(() -> {
            this.shaderPresetGUI.onSave();
            this.config.selectedPreset = Mth.clamp((int)this.config.selectedPreset, (int)0, (int)this.config.presets.size());
            this.config.sortPresets();
            ConfigManager.handler().save();
        }).title((Component)Component.translatable((String)"betterclouds.config.title"));
        for (Tuple<ConfigCategory.Builder, List<Tuple<OptionGroup.Builder, List<Option<?>>>>> categoryPair : this.categories) {
            ConfigCategory.Builder categoryBuilder = (ConfigCategory.Builder)categoryPair.getA();
            for (Tuple groupPair : (List)categoryPair.getB()) {
                OptionGroup.Builder groupBuilder = (OptionGroup.Builder)groupPair.getA();
                if (!((List)groupPair.getB()).isEmpty()) {
                    groupBuilder.options((Collection)groupPair.getB());
                }
                categoryBuilder.group(groupBuilder.build());
            }
            builder.category(categoryBuilder.build());
        }
        return builder;
    }

    static <T> YACLOptionBuilder<T> createOption(Class<T> typeClass, String key) {
        return ConfigGUI.createOption(typeClass, key, true);
    }

    static <T> YACLOptionBuilder<T> createOption(Class<T> typeClass, String key, boolean hasDescription) {
        YACLOptionBuilder builder = YACLOptionBuilder.create(Option.createBuilder()).name(ConfigGUI.optionLabel(key)).instant(true);
        if (hasDescription) {
            builder.description(OptionDescription.of((Component[])new Component[]{ConfigGUI.optionDescription(key)}));
        }
        return builder;
    }

    static Component formatAsBlocksPerSecond(Float value) {
        return Component.translatable((String)"betterclouds.config.unit.blocks_per_second", (Object[])new Object[]{String.format("%.1f", Float.valueOf(value.floatValue() * 20.0f))});
    }

    static Component formatAsPercent(float value) {
        return Component.translatable((String)"betterclouds.config.unit.percent", (Object[])new Object[]{(int)(value * 100.0f)});
    }

    static Component formatAsTimes(float value) {
        return Component.translatable((String)"betterclouds.config.unit.times", (Object[])new Object[]{String.format("%.2f", Float.valueOf(value))});
    }

    static Component formatAsDays(float value) {
        return Component.translatable((String)"gui.days", (Object[])new Object[]{String.format("%.2f", Float.valueOf(value))});
    }

    static Component formatAsDegrees(Float value) {
        return Component.translatable((String)"betterclouds.config.unit.degrees", (Object[])new Object[]{String.format("%.0f", value)});
    }

    static Component formatAsTwoDecimals(Float value) {
        return Component.literal((String)String.format("%,.2f", value).replaceAll("[\u00a0\u202f]", " "));
    }

    static Component categoryLabel(String key) {
        return Component.translatable((String)("betterclouds.config.category." + key));
    }

    static Component groupLabel(String key) {
        return Component.translatable((String)("betterclouds.config.group." + key));
    }

    static Component optionLabel(String key) {
        return Component.translatable((String)("betterclouds.config.entry." + key));
    }

    static Component optionDescription(String key) {
        return Component.translatable((String)("betterclouds.config.entry." + key + ".description"));
    }

    static Component groupDescription(String key) {
        return Component.translatable((String)("betterclouds.config.group." + key + ".description"));
    }
}

