/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.util;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.platform.ModLoader;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public interface DataDirectoryMigration {
    public static void runMigration() {
        File oldDir = ModLoader.getGameDir().resolve("better-clouds").toFile();
        if (!oldDir.exists() || !oldDir.isDirectory()) {
            return;
        }
        File newDir = BetterCloudsStatic.getDataDirectory().toFile();
        if (newDir.exists()) {
            return;
        }
        newDir.mkdirs();
        File[] entries = oldDir.listFiles();
        if (entries == null) {
            return;
        }
        BetterCloudsStatic.getLogger().info("Migrating old data directory 'better-clouds' to new directory 'data/betterclouds'");
        boolean anyError = false;
        for (File entry : entries) {
            try {
                FileUtils.moveToDirectory((File)entry, (File)newDir, (boolean)false);
            }
            catch (IOException ignored) {
                anyError = true;
            }
        }
        if (!anyError) {
            FileUtils.deleteQuietly((File)oldDir);
        } else {
            BetterCloudsStatic.getLogger().info("Some files could not be moved, keeping old directory");
        }
    }
}

