/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.particle;

import java.util.List;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.fx.ConditionalTrailAppearance;
import net.bettercombat.api.fx.ParticlePlacement;
import net.bettercombat.api.fx.TrailAppearance;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.particle.TrailParticles;
import net.bettercombat.config.TrailConfig;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.particle.SlashParticleEffect;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_742;

public class SlashParticleUtil {
    public static void spawnParticles(SpawnArgs args) {
        SlashParticleUtil.spawnParticles(args.player, args.isOffhand, args.weaponRange, args.settingsList, args.appearance);
    }

    public static void spawnParticles(class_742 player, boolean isOffhand, float weaponRange, List<ParticlePlacement> settingsList, TrailAppearance appearance) {
        if (!BetterCombatClientMod.config.isShowingWeaponTrails) {
            return;
        }
        if (settingsList.isEmpty()) {
            return;
        }
        weaponRange -= -0.25f;
        for (ParticlePlacement settings : settingsList) {
            String id = settings.particle_type();
            List<TrailParticles.Entry> trails = TrailParticles.ENTRIES.get(id);
            if (trails == null) continue;
            float offsetX = settings.x_addition();
            float offsetY = settings.y_addition();
            float offsetZ = settings.z_addition();
            float offhandRoll = isOffhand ? 180.0f : 0.0f;
            float offhandFlip = isOffhand ? -1.0f : 1.0f;
            float yaw = player.method_36454();
            float pitch = player.method_36455();
            class_243 right = class_243.method_1030((float)0.0f, (float)(yaw + 90.0f)).method_1029();
            class_243 forward = class_243.method_1030((float)pitch, (float)yaw).method_1029();
            double baseX = player.method_23317();
            double baseY = player.method_23320() - 0.25 + (double)offsetY;
            double baseZ = player.method_23321();
            class_243 finalPosition = new class_243(baseX, baseY, baseZ).method_1019(forward.method_1021((double)offsetZ)).method_1019(right.method_1021((double)(offsetX * offhandFlip)));
            class_243 stabFinalPosition = new class_243(finalPosition.method_10216(), finalPosition.method_10214(), finalPosition.method_10215()).method_1019(forward.method_1021((double)weaponRange - 1.5));
            double x = finalPosition.method_10216();
            double y = finalPosition.method_10214();
            double z = finalPosition.method_10215();
            double xStab = stabFinalPosition.method_10216();
            double yStab = stabFinalPosition.method_10214();
            double zStab = stabFinalPosition.method_10215();
            for (TrailParticles.Entry trail : trails) {
                double posX = trail.stabPosition() ? xStab : x;
                double posY = trail.stabPosition() ? yStab : y;
                double posZ = trail.stabPosition() ? zStab : z;
                for (TrailParticles.LayeredParticle layeredParticle : trail.particles()) {
                    player.method_37908().method_8406((class_2394)new SlashParticleEffect(layeredParticle.bottom(), weaponRange, player.method_36455() + settings.pitch_addition(), player.method_36454(), settings.local_yaw() * offhandFlip, (settings.roll_set() + trail.rollOffset() + offhandRoll) * offhandFlip, appearance.primary.glows(), appearance.primary.color_rgba()), posX, posY, posZ, 0.0, 0.0, 0.0);
                    player.method_37908().method_8406((class_2394)new SlashParticleEffect(layeredParticle.top(), weaponRange, player.method_36455() + settings.pitch_addition(), player.method_36454(), settings.local_yaw() * offhandFlip, (settings.roll_set() + trail.rollOffset() + offhandRoll) * offhandFlip, appearance.secondary.glows(), appearance.secondary.color_rgba()), posX, posY, posZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static List<ParticlePlacement> trailParticlesFromAttack(AttackHand attackHand) {
        if (!attackHand.attack().trailParticles().isEmpty()) {
            return attackHand.attack().trailParticles();
        }
        TrailConfig config = (TrailConfig)BetterCombatMod.trailConfig.value;
        List<ParticlePlacement> animationSpecific = config.animation_based.get(attackHand.attack().animation());
        if (animationSpecific != null) {
            return animationSpecific;
        }
        return List.of();
    }

    public static TrailAppearance appearanceFromItemStack(class_1799 stack) {
        ConditionalTrailAppearance defaults = ((TrailConfig)BetterCombatMod.trailConfig.value).trail_appearance;
        WeaponAttributes weaponAttributes = WeaponRegistry.getAttributes(stack);
        if (weaponAttributes != null && weaponAttributes.trailAppearance() != null) {
            return defaults.merge(weaponAttributes.trailAppearance()).resolve(stack);
        }
        return defaults.resolve(stack);
    }

    public record SpawnArgs(class_742 player, boolean isOffhand, float weaponRange, List<ParticlePlacement> settingsList, TrailAppearance appearance) {
    }

    public record ScheduledSpawnArgs(SpawnArgs args, int time) {
    }
}

