/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.api.fx;

import java.util.LinkedHashMap;
import java.util.Map;
import net.bettercombat.api.fx.ItemConditions;
import net.bettercombat.api.fx.TrailAppearance;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record ConditionalTrailAppearance(TrailAppearance default_appearance, LinkedHashMap<String, TrailAppearance> conditional) {
    public ConditionalTrailAppearance(TrailAppearance default_appearance) {
        this(default_appearance, new LinkedHashMap<String, TrailAppearance>());
    }

    public ConditionalTrailAppearance() {
        this(TrailAppearance.DEFAULT, new LinkedHashMap<String, TrailAppearance>());
    }

    @Nullable
    public TrailAppearance resolve(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return this.default_appearance;
        }
        for (Map.Entry<String, TrailAppearance> entry : this.conditional.entrySet()) {
            String conditionId = entry.getKey();
            if (!ItemConditions.test(conditionId, itemStack)) continue;
            return entry.getValue();
        }
        return this.default_appearance;
    }

    public ConditionalTrailAppearance merge(@Nullable ConditionalTrailAppearance override) {
        if (override == null) {
            return this;
        }
        TrailAppearance mergedDefault = override.default_appearance != null ? override.default_appearance : this.default_appearance;
        LinkedHashMap<String, TrailAppearance> mergedConditional = new LinkedHashMap<String, TrailAppearance>(this.conditional);
        mergedConditional.putAll(override.conditional);
        return new ConditionalTrailAppearance(mergedDefault, mergedConditional);
    }
}

