/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.particle;

import java.util.List;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.fx.ConditionalTrailAppearance;
import net.bettercombat.api.fx.ParticlePlacement;
import net.bettercombat.api.fx.TrailAppearance;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.particle.TrailParticles;
import net.bettercombat.config.TrailConfig;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.particle.SlashParticleEffect;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SlashParticleUtil {
    public static void spawnParticles(SpawnArgs args) {
        SlashParticleUtil.spawnParticles(args.player, args.isOffhand, args.weaponRange, args.settingsList, args.appearance);
    }

    public static void spawnParticles(AbstractClientPlayer player, boolean isOffhand, float weaponRange, List<ParticlePlacement> settingsList, TrailAppearance appearance) {
        if (!BetterCombatClientMod.config.isShowingWeaponTrails) {
            return;
        }
        if (settingsList.isEmpty()) {
            return;
        }
        weaponRange -= -0.25f;
        for (ParticlePlacement settings : settingsList) {
            String id = settings.particle_type();
            List<TrailParticles.Entry> trails = TrailParticles.ENTRIES.get(id);
            if (trails == null) continue;
            float offsetX = settings.x_addition();
            float offsetY = settings.y_addition();
            float offsetZ = settings.z_addition();
            float offhandRoll = isOffhand ? 180.0f : 0.0f;
            float offhandFlip = isOffhand ? -1.0f : 1.0f;
            float yaw = player.getYRot();
            float pitch = player.getXRot();
            Vec3 right = Vec3.directionFromRotation((float)0.0f, (float)(yaw + 90.0f)).normalize();
            Vec3 forward = Vec3.directionFromRotation((float)pitch, (float)yaw).normalize();
            double baseX = player.getX();
            double baseY = player.getEyeY() - 0.25 + (double)offsetY;
            double baseZ = player.getZ();
            Vec3 finalPosition = new Vec3(baseX, baseY, baseZ).add(forward.scale((double)offsetZ)).add(right.scale((double)(offsetX * offhandFlip)));
            Vec3 stabFinalPosition = new Vec3(finalPosition.x(), finalPosition.y(), finalPosition.z()).add(forward.scale((double)weaponRange - 1.5));
            double x = finalPosition.x();
            double y = finalPosition.y();
            double z = finalPosition.z();
            double xStab = stabFinalPosition.x();
            double yStab = stabFinalPosition.y();
            double zStab = stabFinalPosition.z();
            for (TrailParticles.Entry trail : trails) {
                double posX = trail.stabPosition() ? xStab : x;
                double posY = trail.stabPosition() ? yStab : y;
                double posZ = trail.stabPosition() ? zStab : z;
                for (TrailParticles.LayeredParticle layeredParticle : trail.particles()) {
                    player.level().addParticle((ParticleOptions)new SlashParticleEffect(layeredParticle.bottom(), weaponRange, player.getXRot() + settings.pitch_addition(), player.getYRot(), settings.local_yaw() * offhandFlip, (settings.roll_set() + trail.rollOffset() + offhandRoll) * offhandFlip, appearance.primary.glows(), appearance.primary.color_rgba()), posX, posY, posZ, 0.0, 0.0, 0.0);
                    player.level().addParticle((ParticleOptions)new SlashParticleEffect(layeredParticle.top(), weaponRange, player.getXRot() + settings.pitch_addition(), player.getYRot(), settings.local_yaw() * offhandFlip, (settings.roll_set() + trail.rollOffset() + offhandRoll) * offhandFlip, appearance.secondary.glows(), appearance.secondary.color_rgba()), posX, posY, posZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static List<ParticlePlacement> trailParticlesFromAttack(AttackHand attackHand) {
        if (!attackHand.attack().trailParticles().isEmpty()) {
            return attackHand.attack().trailParticles();
        }
        TrailConfig config = (TrailConfig)BetterCombatMod.trailConfig.value;
        List<ParticlePlacement> animationSpecific = config.animation_based.get(attackHand.attack().animation());
        if (animationSpecific != null) {
            return animationSpecific;
        }
        return List.of();
    }

    public static TrailAppearance appearanceFromItemStack(ItemStack stack) {
        ConditionalTrailAppearance defaults = ((TrailConfig)BetterCombatMod.trailConfig.value).trail_appearance;
        WeaponAttributes weaponAttributes = WeaponRegistry.getAttributes(stack);
        if (weaponAttributes != null && weaponAttributes.trailAppearance() != null) {
            return defaults.merge(weaponAttributes.trailAppearance()).resolve(stack);
        }
        return defaults.resolve(stack);
    }

    public record SpawnArgs(AbstractClientPlayer player, boolean isOffhand, float weaponRange, List<ParticlePlacement> settingsList, TrailAppearance appearance) {
    }

    public record ScheduledSpawnArgs(SpawnArgs args, int time) {
    }
}

