/*
 * Decompiled with CFR 0.152.
 */
package net.norevy.optileaves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public final class Settings {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("optileaves.json");
    public boolean enabled = true;
    public int depth = 3;

    public static void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            Settings.save();
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(FILE);){
            Settings s = (Settings)GSON.fromJson((Reader)r, Settings.class);
            if (s == null) {
                s = new Settings();
            }
            if (s.depth < 1 || s.depth > 4) {
                s.depth = 2;
            }
            Holder.set(s);
        }
        catch (IOException e) {
            Holder.set(new Settings());
        }
    }

    public static void save() {
        Settings s = Holder.get();
        if (s.depth < 1) {
            s.depth = 1;
        }
        if (s.depth > 4) {
            s.depth = 4;
        }
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(FILE, new OpenOption[0]);){
                GSON.toJson((Object)s, (Appendable)w);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class Holder {
        private static Settings INSTANCE = new Settings();

        public static Settings get() {
            return INSTANCE;
        }

        public static void set(Settings s) {
            INSTANCE = s;
        }
    }
}

