/*
 * Decompiled with CFR 0.152.
 */
package yelf42.cropcritters.mixin;

import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yelf42.cropcritters.blocks.ModBlocks;
import yelf42.cropcritters.config.ConfigManager;
import yelf42.cropcritters.entity.ModEntities;

@Mixin(value={class_2302.class})
public abstract class CropBlockMixin {
    @Inject(method={"canPlantOnTop"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowPlantOnSoulAndDirt(class_2680 floor, class_1922 world, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (floor.method_26164(class_3481.field_29822)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getAvailableMoisture"}, at={@At(value="HEAD")}, cancellable=true)
    private static void soulBasedMoisture(class_2248 block, class_1922 world, class_2338 pos, CallbackInfoReturnable<Float> cir) {
        class_2680 blockState = world.method_8320(pos.method_10074());
        if (blockState.method_27852(ModBlocks.SOUL_FARMLAND)) {
            cir.setReturnValue((Object)Float.valueOf(18.0f));
        }
    }

    @Inject(method={"hasRandomTicks"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideMatureStoppingRandomTicks(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"randomTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z", shift=At.Shift.AFTER)})
    private static void removeNutrientsAndSpawnCritters(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            if (cropBlock.method_9829(state) + 1 != cropBlock.method_9827()) {
                return;
            }
            class_2680 soilCheck = world.method_8320(pos.method_10074());
            if (soilCheck.method_27852(class_2246.field_10362)) {
                class_2248.method_9582((class_2680)class_2246.field_10362.method_9564(), (class_2680)class_2246.field_10566.method_9564(), (class_1936)world, (class_2338)pos.method_10074());
                class_2680 toDirt = random.method_43048(4) == 0 ? class_2246.field_10566.method_9564() : (random.method_43048(2) == 0 ? class_2246.field_28685.method_9564() : class_2246.field_10253.method_9564());
                world.method_8652(pos.method_10074(), toDirt, 2);
            } else if (soilCheck.method_27852(ModBlocks.SOUL_FARMLAND)) {
                class_2248.method_9582((class_2680)class_2246.field_10362.method_9564(), (class_2680)class_2246.field_22090.method_9564(), (class_1936)world, (class_2338)pos.method_10074());
                class_2680 toDirt = random.method_43048(2) == 0 ? class_2246.field_22090.method_9564() : class_2246.field_10114.method_9564();
                world.method_8652(pos.method_10074(), toDirt, 2);
            } else {
                return;
            }
            if (CropBlockMixin.spawnCritter(world, state, random, pos)) {
                return;
            }
        }
    }

    @Inject(method={"randomTick"}, at={@At(value="HEAD")}, cancellable=true)
    private static void stopGrowthOnDirtAndSpawnSoulSandValleyCritters(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        class_2680 soilCheck = world.method_8320(pos.method_10074());
        if (!soilCheck.method_27852(class_2246.field_10362) && !soilCheck.method_27852(ModBlocks.SOUL_FARMLAND)) {
            ci.cancel();
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            if (world.method_23753(pos).method_40225(class_1972.field_22076) && cropBlock.method_9825(state) && CropBlockMixin.spawnCritter(world, state, random, pos)) {
                return;
            }
            if (random.method_43058() < 0.03 * ((double)cropBlock.method_9829(state) / (double)(cropBlock.method_9827() - 1))) {
                CropBlockMixin.generateWeed(state, world, pos, random, soilCheck.method_27852(ModBlocks.SOUL_FARMLAND));
            }
        }
    }

    @Unique
    private static void generateWeed(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, boolean nether) {
        boolean growNetherWeed;
        float monoCount = 1.0f;
        if (ConfigManager.CONFIG.monoculturePenalize) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == j && j == 0) continue;
                    class_2680 cropToCheck = world.method_8320(pos.method_10069(i, 0, j));
                    monoCount += cropToCheck.method_27852(state.method_26204()) ? 1.0f : 0.0f;
                }
            }
            monoCount = monoCount * monoCount / 8.0f;
        }
        boolean growOverworldWeed = (float)(random.method_43048(100) + 1) < (float)ConfigManager.CONFIG.regularWeedChance + monoCount;
        boolean bl = growNetherWeed = (float)(random.method_43048(100) + 1) < (float)ConfigManager.CONFIG.netherWeedChance + monoCount;
        if (!growOverworldWeed && !growNetherWeed) {
            return;
        }
        int weedTypeCheck = random.method_43048(100) + 1;
        if (world.method_23753(pos).method_40225(class_1972.field_22076)) {
            if (growNetherWeed && nether) {
                class_2680 weedState = ModBlocks.WITHERING_SPITEWEED.method_9564();
                world.method_8501(pos, weedState);
                class_2248.method_9582((class_2680)class_2246.field_10114.method_9564(), (class_2680)class_2246.field_23869.method_9564(), (class_1936)world, (class_2338)pos.method_10074());
                world.method_8652(pos.method_10074(), class_2246.field_23869.method_9564(), 2);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)weedState));
                return;
            }
        } else {
            if (growOverworldWeed && !nether) {
                class_2680 weedState = ModBlocks.CRAWL_THISTLE.method_9564();
                world.method_8501(pos, weedState);
                class_2248.method_9582((class_2680)class_2246.field_10362.method_9564(), (class_2680)class_2246.field_10253.method_9564(), (class_1936)world, (class_2338)pos.method_10074());
                world.method_8652(pos.method_10074(), class_2246.field_10253.method_9564(), 2);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)weedState));
                return;
            }
            if (nether && growNetherWeed) {
                class_2680 weedState = ModBlocks.CRIMSON_THORNWEED.method_9564();
                if (weedTypeCheck < 20) {
                    weedState = ModBlocks.WAFTGRASS.method_9564();
                }
                world.method_8501(pos, weedState);
                class_2248.method_9582((class_2680)ModBlocks.SOUL_FARMLAND.method_9564(), (class_2680)class_2246.field_22090.method_9564(), (class_1936)world, (class_2338)pos.method_10074());
                world.method_8652(pos.method_10074(), random.method_43048(2) == 0 ? class_2246.field_22090.method_9564() : class_2246.field_10114.method_9564(), 2);
                world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)weedState));
                return;
            }
        }
    }

    @Unique
    private static boolean spawnCritter(class_3218 world, class_2680 state, class_5819 random, class_2338 pos) {
        class_2680 soulCheck = world.method_8320(pos.method_10074());
        boolean soulCheckBl = soulCheck.method_27852(class_2246.field_22090) || soulCheck.method_27852(class_2246.field_10114) || soulCheck.method_27852(ModBlocks.SOUL_FARMLAND);
        boolean airCheck = world.method_8320(pos.method_10084()).method_26215();
        int spawnChance = ConfigManager.CONFIG.critterSpawnChance;
        if (airCheck && random.method_43048(100) + 1 < (spawnChance *= soulCheckBl ? 2 : 1)) {
            if (state.method_27852(class_2246.field_10293)) {
                ModEntities.WHEAT_CRITTER.method_47821(world, pos, class_3730.field_16459);
            } else if (state.method_27852(class_2246.field_10609)) {
                ModEntities.CARROT_CRITTER.method_47821(world, pos, class_3730.field_16459);
            } else if (state.method_27852(class_2246.field_10247)) {
                if (random.method_43048(100) + 1 < world.method_8407().method_5461() * 2) {
                    ModEntities.POISONOUS_POTATO_CRITTER.method_47821(world, pos, class_3730.field_16459);
                } else {
                    ModEntities.POTATO_CRITTER.method_47821(world, pos, class_3730.field_16459);
                }
            } else if (state.method_27852(class_2246.field_10341)) {
                ModEntities.BEETROOT_CRITTER.method_47821(world, pos, class_3730.field_16459);
            } else if (state.method_27852(class_2246.field_42749)) {
                ModEntities.TORCHFLOWER_CRITTER.method_47821(world, pos, class_3730.field_16459);
            } else {
                return false;
            }
            world.method_8652(pos, class_2246.field_10124.method_9564(), 2);
            world.method_8396(null, pos, class_3417.field_38365, class_3419.field_15245, 1.0f, 1.0f);
            world.method_65096((class_2394)class_2398.field_22246, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
            return true;
        }
        return false;
    }
}

