/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwterraformersmc;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwterraformersmc.Recipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mcwterraformersmc")
public class McwTerraformersMC
extends McwMod {
    public static final String MODID = "mcwterraformersmc";
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final List<String> WOODS_TRAVERSE = List.of("fir");
    protected static final List<String> WOODS_CINDERSCAPES = List.of("scorched", "umbral");
    protected static final List<String> WOODS_TERRESTRIA = List.of("redwood", "hemlock", "rubber", "cypress", "willow", "japanese_maple", "rainbow_eucalyptus", "sakura", "yucca_palm");
    protected static final List<String> ROCKS_CINDERSCAPES = List.of("sulfur_quartz_bricks", "rose_quartz_bricks", "smoky_quartz_bricks");
    protected static final List<String> ROCKS_TERRESTRIA = List.of("basalt_bricks", "mossy_basalt_bricks");
    protected static final List<String> LEAVES_TRAVERSE = List.of("fir", "red_autumnal", "brown_autumnal", "orange_autumnal", "yellow_autumnal");
    protected static final List<String> LEAVES_TERRESTRIA = List.of("redwood", "hemlock", "rubber", "cypress", "willow", "japanese_maple", "rainbow_eucalyptus", "sakura", "yucca_palm", "japanese_maple_shrub", "dark_japanese_maple", "jungle_palm");
    private static final DeferredRegister<Block> BLOCKS = Registration.blocks((String)"mcwterraformersmc");
    private static final DeferredRegister<Item> ITEMS = Registration.items((String)"mcwterraformersmc");
    public static final CreativeModeTab MCWTERRAFORMERSMC_TAB = new CreativeModeTab("mcwterraformersmc.tab"){

        @Nonnull
        public ItemStack m_6976_() {
            NewIconRandom.NewProperties propIcon = new NewIconRandom.NewProperties(Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_planks_roof")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_pyramid_gate")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_bookshelf_drawer")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_log_bridge_middle")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_four_window")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_barn_glass_door")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_blossom_trapdoor")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_planks_path")), Finder.findBlock((String)McwTerraformersMC.MODID, (String)(McwTerraformersMC.randomNaming() + "_skyline_stairs")));
            propIcon.addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.STAIRS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.TRAPDOORS);
            Block icon = propIcon.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.STAIRS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.TRAPDOORS});
            return new ItemStack((ItemLike)icon);
        }
    };

    public McwTerraformersMC() {
        LOGGER.info("Macaw's TerraformersMC Loading...");
        Registration.init(BLOCKS, ITEMS);
        BlockBehaviour.Properties wood = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_);
        BlockBehaviour.Properties stone = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50652_);
        BlockBehaviour.Properties leave = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_);
        Bridges.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse", (BlockBehaviour.Properties)wood);
        Bridges.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)wood);
        Bridges.setRegistrationRockModLoaded(ROCKS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)stone);
        Bridges.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)wood);
        Bridges.setRegistrationRockModLoaded(ROCKS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)stone);
        Roofs.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse", (BlockBehaviour.Properties)wood);
        Roofs.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)wood);
        Roofs.setRegistrationRockModLoaded(ROCKS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)stone);
        Roofs.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)wood);
        Roofs.setRegistrationRockModLoaded(ROCKS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)stone);
        Fences.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse", (BlockBehaviour.Properties)wood);
        Fences.setRegistrationHedgesModLoaded(LEAVES_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse", (BlockBehaviour.Properties)leave);
        Fences.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)wood);
        Fences.setRegistrationRockModLoaded(ROCKS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)stone);
        Fences.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)wood);
        Fences.setRegistrationHedgesModLoaded(LEAVES_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)leave);
        Fences.setRegistrationRockModLoaded(ROCKS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)stone);
        Furnitures.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse");
        Furnitures.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes");
        Furnitures.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria");
        Stairs.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse", (BlockBehaviour.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes", (BlockBehaviour.Properties)wood);
        Stairs.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria", (BlockBehaviour.Properties)wood);
        Paths.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse");
        Paths.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes");
        Paths.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria");
        Doors.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse");
        Doors.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes");
        Doors.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria");
        Trapdoors.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse");
        Trapdoors.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes");
        Trapdoors.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria");
        Windows.setRegistrationWoodModLoaded(WOODS_TRAVERSE, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"traverse");
        Windows.setRegistrationWoodModLoaded(WOODS_CINDERSCAPES, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"cinderscapes");
        Windows.setRegistrationWoodModLoaded(WOODS_TERRESTRIA, BLOCKS, ITEMS, (CreativeModeTab)MCWTERRAFORMERSMC_TAB, (String)"terrestria");
        this.bus().addListener(this::clientSetup);
        this.bus().addListener(this::commonSetup);
        this.bus().addListener(this::dataSetup);
        LOGGER.info("Macaw's TerraformersMC Is Charged !");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOODS_TRAVERSE, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES_TRAVERSE);
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOODS_CINDERSCAPES, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, ROCKS_CINDERSCAPES, (ModType[])Registration.getAllModTypeStone());
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOODS_TERRESTRIA, (ModType[])Registration.getAllModTypeWood());
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES_TERRESTRIA);
        APIRenderTypes.initAllStone((FMLClientSetupEvent)event, (String)MODID, ROCKS_TERRESTRIA, (ModType[])Registration.getAllModTypeStone());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOODS_TRAVERSE);
            McwLootTables.addBlockHedges((String)MODID, LEAVES_TRAVERSE);
            McwLootTables.addBlockAllWood((String)MODID, WOODS_CINDERSCAPES);
            McwLootTables.addBlockAllStone((String)MODID, ROCKS_CINDERSCAPES);
            McwLootTables.addBlockAllWood((String)MODID, WOODS_TERRESTRIA);
            McwLootTables.addBlockHedges((String)MODID, LEAVES_TERRESTRIA);
            McwLootTables.addBlockAllStone((String)MODID, ROCKS_TERRESTRIA);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        if (gatherDataEvent.includeServer()) {
            McwBlockTags mcwBlockTags = new McwBlockTags(generator, MODID, existingFileHelper){

                protected void m_6577_() {
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_TRAVERSE, LEAVES_TRAVERSE);
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_CINDERSCAPES, ROCKS_CINDERSCAPES, new ArrayList());
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_TERRESTRIA, ROCKS_TERRESTRIA, LEAVES_TERRESTRIA);
                }
            };
            generator.m_236039_(true, (DataProvider)new Recipes(generator));
            generator.m_236039_(true, (DataProvider)mcwBlockTags);
            generator.m_236039_(true, (DataProvider)new McwItemTags(generator, (BlockTagsProvider)mcwBlockTags, MODID, existingFileHelper){

                protected void m_6577_() {
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_TRAVERSE, LEAVES_TRAVERSE);
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_CINDERSCAPES, ROCKS_CINDERSCAPES, new ArrayList());
                    this.addAllMcwTags(McwTerraformersMC.MODID, WOODS_TERRESTRIA, ROCKS_TERRESTRIA, LEAVES_TERRESTRIA);
                }
            });
        }
    }

    private static String randomNaming() {
        Random rand = new Random();
        if (ModList.get().isLoaded("traverse") && ModList.get().isLoaded("cinderscapes") && ModList.get().isLoaded("terrestria")) {
            int i = rand.nextInt(3);
            return switch (i) {
                case 0 -> "umbral";
                case 1 -> "fir";
                case 2 -> "japanese_maple";
                default -> "redwood";
            };
        }
        if (ModList.get().isLoaded("cinderscapes")) {
            return "umbral";
        }
        if (ModList.get().isLoaded("traverse")) {
            return "fir";
        }
        if (ModList.get().isLoaded("terrestria")) {
            return "japanese_maple";
        }
        return "fir";
    }
}

