/*
 * Decompiled with CFR 0.152.
 */
package com.triviachallenge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TriviaChallenge
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private final Map<UUID, Challenge> activePlayerChallenges = new ConcurrentHashMap<UUID, Challenge>();
    private final Random random = new Random();
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private BukkitTask challengeTask = null;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("trivia").setExecutor((CommandExecutor)new TriviaCommand());
        this.getCommand("triviaadmin").setExecutor((CommandExecutor)new TriviaAdminCommand());
        this.startAutomaticChallenges();
        this.getLogger().info("TriviaChallenge has been enabled!");
    }

    public void onDisable() {
        if (this.challengeTask != null) {
            this.challengeTask.cancel();
        }
        this.getLogger().info("TriviaChallenge has been disabled!");
    }

    private void startAutomaticChallenges() {
        if (!this.config.getBoolean("auto-challenges.enabled")) {
            return;
        }
        long interval = this.config.getLong("auto-challenges.interval") * 20L;
        this.challengeTask = new BukkitRunnable(){

            public void run() {
                if (Bukkit.getOnlinePlayers().size() < TriviaChallenge.this.config.getInt("auto-challenges.min-players", 1)) {
                    return;
                }
                String challengeType = TriviaChallenge.this.getRandomChallengeType();
                final Challenge challenge = TriviaChallenge.this.generateChallenge(challengeType);
                if (challenge != null) {
                    Bukkit.broadcastMessage((String)TriviaChallenge.this.formatMessage("global-challenge-start"));
                    Bukkit.broadcastMessage((String)TriviaChallenge.this.formatMessage("challenge-broadcast").replace("{CHALLENGE}", challenge.getQuestion()));
                    UUID globalChallengeId = UUID.randomUUID();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.hasPermission("triviachallenge.participate")) continue;
                        TriviaChallenge.this.activePlayerChallenges.put(player.getUniqueId(), challenge);
                    }
                    int timeout = TriviaChallenge.this.config.getInt("challenge-timeout", 30);
                    new BukkitRunnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                this.this$1.TriviaChallenge.this.activePlayerChallenges.remove(player.getUniqueId());
                            }
                            Bukkit.broadcastMessage((String)this.this$1.TriviaChallenge.this.formatMessage("challenge-expired").replace("{ANSWER}", challenge.getAnswer()));
                        }
                    }.runTaskLater((Plugin)TriviaChallenge.this, (long)timeout * 20L);
                }
            }
        }.runTaskTimer((Plugin)this, interval, interval);
    }

    private String getRandomChallengeType() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.config.getBoolean("challenges.trivia.enabled")) {
            types.add("trivia");
        }
        if (this.config.getBoolean("challenges.math.enabled")) {
            types.add("math");
        }
        if (this.config.getBoolean("challenges.captcha.enabled")) {
            types.add("captcha");
        }
        if (types.isEmpty()) {
            return "trivia";
        }
        return (String)types.get(this.random.nextInt(types.size()));
    }

    private Challenge generateChallenge(String type) {
        switch (type) {
            case "trivia": {
                return this.generateTriviaChallenge();
            }
            case "math": {
                return this.generateMathChallenge();
            }
            case "captcha": {
                return this.generateCaptchaChallenge();
            }
        }
        return this.generateTriviaChallenge();
    }

    private Challenge generateTriviaChallenge() {
        List questions = this.config.getMapList("challenges.trivia.questions");
        if (questions.isEmpty()) {
            return new Challenge("What is the capital of France?", "Paris", "trivia");
        }
        Map questionData = (Map)questions.get(this.random.nextInt(questions.size()));
        String question = (String)questionData.get("question");
        String answer = (String)questionData.get("answer");
        return new Challenge(question, answer, "trivia");
    }

    private Challenge generateMathChallenge() {
        String operator;
        int num1;
        int difficulty = this.config.getInt("challenges.math.difficulty", 1);
        int num2 = switch (difficulty) {
            case 1 -> {
                num1 = this.random.nextInt(10) + 1;
                yield this.random.nextInt(10) + 1;
            }
            case 2 -> {
                num1 = this.random.nextInt(50) + 1;
                yield this.random.nextInt(50) + 1;
            }
            case 3 -> {
                num1 = this.random.nextInt(100) + 1;
                yield this.random.nextInt(100) + 1;
            }
            default -> {
                num1 = this.random.nextInt(20) + 1;
                yield this.random.nextInt(20) + 1;
            }
        };
        String[] operators = new String[]{"+", "-", "*"};
        return new Challenge("What is " + num1 + " " + operator + " " + num2 + "?", switch (operator = operators[this.random.nextInt(operators.length)]) {
            case "+" -> String.valueOf(num1 + num2);
            case "-" -> {
                if (num1 < num2) {
                    int temp = num1;
                    num1 = num2;
                    num2 = temp;
                }
                yield String.valueOf(num1 - num2);
            }
            case "*" -> String.valueOf(num1 * num2);
            default -> String.valueOf(num1 + num2);
        }, "math");
    }

    private Challenge generateCaptchaChallenge() {
        int length = this.config.getInt("challenges.captcha.length", 5);
        boolean useLetters = this.config.getBoolean("challenges.captcha.use-letters", true);
        boolean useNumbers = this.config.getBoolean("challenges.captcha.use-numbers", true);
        StringBuilder captcha = new StringBuilder();
        Object chars = "";
        if (useLetters) {
            chars = (String)chars + "ABCDEFGHJKLMNPQRSTUVWXYZ";
        }
        if (useNumbers) {
            chars = (String)chars + "23456789";
        }
        if (((String)chars).isEmpty()) {
            chars = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
        }
        for (int i = 0; i < length; ++i) {
            captcha.append(((String)chars).charAt(this.random.nextInt(((String)chars).length())));
        }
        return new Challenge("Type the following code: " + String.valueOf(captcha), captcha.toString(), "captcha");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.activePlayerChallenges.containsKey(playerId)) {
            return;
        }
        Challenge challenge = this.activePlayerChallenges.get(playerId);
        String message = event.getMessage().trim();
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            if (this.isChallengeAnswerValid(challenge, message)) {
                this.activePlayerChallenges.remove(playerId);
                player.sendMessage(this.formatMessage("correct-answer"));
                this.giveReward(player, challenge.getType());
                int cooldownTime = this.config.getInt("answer-cooldown", 60);
                if (cooldownTime > 0) {
                    this.cooldowns.put(playerId, System.currentTimeMillis() + (long)cooldownTime * 1000L);
                }
            }
        });
    }

    private boolean isChallengeAnswerValid(Challenge challenge, String answer) {
        if (challenge.getType().equals("captcha")) {
            return challenge.getAnswer().equals(answer);
        }
        if (challenge.getType().equals("math")) {
            try {
                double expectedAnswer = Double.parseDouble(challenge.getAnswer());
                double providedAnswer = Double.parseDouble(answer);
                return Math.abs(expectedAnswer - providedAnswer) < 0.001;
            }
            catch (NumberFormatException e) {
                return challenge.getAnswer().equalsIgnoreCase(answer);
            }
        }
        return challenge.getAnswer().equalsIgnoreCase(answer);
    }

    private void giveReward(Player player, String challengeType) {
        String rewardType = this.config.getString("rewards." + challengeType + ".type", "command");
        if (rewardType.equalsIgnoreCase("item")) {
            Material material = Material.valueOf((String)this.config.getString("rewards." + challengeType + ".item", "DIAMOND"));
            int amount = this.config.getInt("rewards." + challengeType + ".amount", 1);
            ItemStack reward = new ItemStack(material, amount);
            player.getInventory().addItem(new ItemStack[]{reward});
            player.sendMessage(this.formatMessage("reward-item").replace("{AMOUNT}", String.valueOf(amount)).replace("{ITEM}", material.toString()));
        } else if (rewardType.equalsIgnoreCase("command")) {
            List commands = this.config.getStringList("rewards." + challengeType + ".commands");
            for (String cmd : commands) {
                cmd = cmd.replace("{PLAYER}", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
            player.sendMessage(this.formatMessage("reward-command"));
        }
    }

    private String formatMessage(String path) {
        String message = this.config.getString("messages." + path, "&cMessage not found: " + path);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void openTriviaGUI(Player player) {
        player.sendMessage(this.formatMessage("gui-header"));
        player.sendMessage(this.formatMessage("gui-start-challenge"));
        player.sendMessage(this.formatMessage("gui-view-stats"));
        player.sendMessage(this.formatMessage("gui-help"));
    }

    public class TriviaCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            final Player player = (Player)sender;
            if (!player.hasPermission("triviachallenge.use")) {
                player.sendMessage(TriviaChallenge.this.formatMessage("no-permission"));
                return true;
            }
            if (args.length == 0) {
                TriviaChallenge.this.openTriviaGUI(player);
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "start": {
                    if (TriviaChallenge.this.activePlayerChallenges.containsKey(player.getUniqueId())) {
                        player.sendMessage(TriviaChallenge.this.formatMessage("challenge-already-active"));
                        return true;
                    }
                    long cooldownTime = TriviaChallenge.this.cooldowns.getOrDefault(player.getUniqueId(), 0L);
                    if (System.currentTimeMillis() < cooldownTime) {
                        long timeLeft = (cooldownTime - System.currentTimeMillis()) / 1000L;
                        player.sendMessage(TriviaChallenge.this.formatMessage("cooldown-active").replace("{TIME}", String.valueOf(timeLeft)));
                        return true;
                    }
                    String challengeType = TriviaChallenge.this.getRandomChallengeType();
                    final Challenge challenge = TriviaChallenge.this.generateChallenge(challengeType);
                    if (challenge == null) break;
                    TriviaChallenge.this.activePlayerChallenges.put(player.getUniqueId(), challenge);
                    player.sendMessage(TriviaChallenge.this.formatMessage("challenge-start"));
                    player.sendMessage(TriviaChallenge.this.formatMessage("challenge-question").replace("{CHALLENGE}", challenge.getQuestion()));
                    int timeout = TriviaChallenge.this.config.getInt("challenge-timeout", 30);
                    new BukkitRunnable(this){
                        final /* synthetic */ TriviaCommand this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            if (this.this$1.TriviaChallenge.this.activePlayerChallenges.containsKey(player.getUniqueId())) {
                                this.this$1.TriviaChallenge.this.activePlayerChallenges.remove(player.getUniqueId());
                                player.sendMessage(this.this$1.TriviaChallenge.this.formatMessage("challenge-expired").replace("{ANSWER}", challenge.getAnswer()));
                            }
                        }
                    }.runTaskLater((Plugin)TriviaChallenge.this, (long)timeout * 20L);
                    break;
                }
                case "help": {
                    player.sendMessage(TriviaChallenge.this.formatMessage("help-header"));
                    player.sendMessage(TriviaChallenge.this.formatMessage("help-start"));
                    player.sendMessage(TriviaChallenge.this.formatMessage("help-stats"));
                    if (!player.hasPermission("triviachallenge.admin")) break;
                    player.sendMessage(TriviaChallenge.this.formatMessage("help-admin"));
                    break;
                }
                default: {
                    player.sendMessage(TriviaChallenge.this.formatMessage("unknown-command"));
                }
            }
            return true;
        }
    }

    public class TriviaAdminCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!sender.hasPermission("triviachallenge.admin")) {
                sender.sendMessage(TriviaChallenge.this.formatMessage("no-permission"));
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(TriviaChallenge.this.formatMessage("admin-help-header"));
                sender.sendMessage(TriviaChallenge.this.formatMessage("admin-help-reload"));
                sender.sendMessage(TriviaChallenge.this.formatMessage("admin-help-start"));
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    TriviaChallenge.this.reloadConfig();
                    TriviaChallenge.this.config = TriviaChallenge.this.getConfig();
                    if (TriviaChallenge.this.challengeTask != null) {
                        TriviaChallenge.this.challengeTask.cancel();
                    }
                    TriviaChallenge.this.startAutomaticChallenges();
                    sender.sendMessage(TriviaChallenge.this.formatMessage("config-reloaded"));
                    break;
                }
                case "start": {
                    if (args.length < 2) {
                        sender.sendMessage(TriviaChallenge.this.formatMessage("specify-challenge-type"));
                        return true;
                    }
                    String challengeType = args[1].toLowerCase();
                    if (!Arrays.asList("trivia", "math", "captcha").contains(challengeType)) {
                        sender.sendMessage(TriviaChallenge.this.formatMessage("invalid-challenge-type"));
                        return true;
                    }
                    final Challenge challenge = TriviaChallenge.this.generateChallenge(challengeType);
                    if (challenge == null) break;
                    Bukkit.broadcastMessage((String)TriviaChallenge.this.formatMessage("global-challenge-start"));
                    Bukkit.broadcastMessage((String)TriviaChallenge.this.formatMessage("challenge-broadcast").replace("{CHALLENGE}", challenge.getQuestion()));
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.hasPermission("triviachallenge.participate")) continue;
                        TriviaChallenge.this.activePlayerChallenges.put(player.getUniqueId(), challenge);
                    }
                    int timeout = TriviaChallenge.this.config.getInt("challenge-timeout", 30);
                    new BukkitRunnable(this){
                        final /* synthetic */ TriviaAdminCommand this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                this.this$1.TriviaChallenge.this.activePlayerChallenges.remove(player.getUniqueId());
                            }
                            Bukkit.broadcastMessage((String)this.this$1.TriviaChallenge.this.formatMessage("challenge-expired").replace("{ANSWER}", challenge.getAnswer()));
                        }
                    }.runTaskLater((Plugin)TriviaChallenge.this, (long)timeout * 20L);
                    break;
                }
                default: {
                    sender.sendMessage(TriviaChallenge.this.formatMessage("unknown-admin-command"));
                }
            }
            return true;
        }
    }

    private static class Challenge {
        private final String question;
        private final String answer;
        private final String type;

        public Challenge(String question, String answer, String type) {
            this.question = question;
            this.answer = answer;
            this.type = type;
        }

        public String getQuestion() {
            return this.question;
        }

        public String getAnswer() {
            return this.answer;
        }

        public String getType() {
            return this.type;
        }
    }
}

