/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.noteblocktuner;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.a5ho9999.noteblocktuner.NoteBlockInteractionUtil;
import net.a5ho9999.noteblocktuner.NoteBlockTunerMod;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class NoteBlockTuner {
    private static final Map<class_2338, TuningOperation> activeTuningOperations = new HashMap<class_2338, TuningOperation>();
    private static final Queue<TuningOperation> tuningQueue = new LinkedList<TuningOperation>();

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || client.field_1761 == null) {
                return;
            }
            NoteBlockTuner.processQueue();
            Iterator<Map.Entry<class_2338, TuningOperation>> iterator = activeTuningOperations.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_2338, TuningOperation> entry = iterator.next();
                TuningOperation operation = entry.getValue();
                ++operation.currentTicks;
                int requiredDelay = NoteBlockTuner.calculateDelay(client, operation);
                if (operation.currentTicks < requiredDelay) continue;
                operation.currentTicks = 0;
                class_2680 state = client.field_1687.method_8320(operation.pos);
                if (state.method_26204() == class_2246.field_10179) {
                    int currentNote = (Integer)state.method_11654((class_2769)class_2428.field_11324);
                    if (currentNote == operation.targetNote) {
                        iterator.remove();
                        if (client.field_1724 == null) continue;
                        client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.TUNING_COMPLETED, (Object[])new Object[]{NoteBlockTuner.posToString(operation.pos), operation.targetNote}), true);
                        continue;
                    }
                    NoteBlockTuner.performNoteBlockTuning(client, operation.pos);
                    continue;
                }
                iterator.remove();
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.BLOCK_REMOVED_DURING_TUNING, (Object[])new Object[]{NoteBlockTuner.posToString(operation.pos)}), true);
            }
        });
    }

    private static void processQueue() {
        int maxConcurrent = NoteBlockTunerMod.getConfig().getConcurrentTuning();
        while (activeTuningOperations.size() < maxConcurrent && !tuningQueue.isEmpty()) {
            TuningOperation operation = tuningQueue.poll();
            if (operation == null) continue;
            activeTuningOperations.put(operation.pos, operation);
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) continue;
            client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.AUTO_TUNING_STARTED, (Object[])new Object[]{NoteBlockTuner.posToString(operation.pos), operation.targetNote}), true);
        }
    }

    private static void performNoteBlockTuning(@NotNull class_310 client, class_2338 pos) {
        if (client.field_1724 != null && client.field_1761 != null) {
            client.execute(() -> {
                boolean success = NoteBlockInteractionUtil.interactWithNoteBlock(client, pos);
                if (!success) {
                    NoteBlockTunerMod.onLog("Failed to interact with Note Block at {} during auto-tuning", NoteBlockTuner.posToString(pos));
                }
            });
        }
    }

    public static void setAutoTuning(class_2338 pos, int note) {
        class_310 client = class_310.method_1551();
        if (activeTuningOperations.containsKey(pos)) {
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.ALREADY_BEING_TUNED, (Object[])new Object[]{NoteBlockTuner.posToString(pos)}), true);
            }
            return;
        }
        if (tuningQueue.stream().anyMatch(op -> op.pos.equals((Object)pos))) {
            if (client.field_1724 != null) {
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.ALREADY_QUEUED_FOR_TUNING, (Object[])new Object[]{NoteBlockTuner.posToString(pos)}), true);
            }
            return;
        }
        if (client.field_1687 != null) {
            class_2680 state = client.field_1687.method_8320(pos);
            if (state.method_26204() != class_2246.field_10179) {
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.NOT_A_NOTE_BLOCK, (Object[])new Object[]{NoteBlockTuner.posToString(pos)}), true);
                }
                return;
            }
            int currentNote = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            if (currentNote == note) {
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.ALREADY_AT_TARGET_NOTE, (Object[])new Object[]{NoteBlockTuner.posToString(pos), note}), true);
                }
                return;
            }
            TuningOperation operation = new TuningOperation(pos, note, currentNote);
            int maxConcurrent = NoteBlockTunerMod.getConfig().getConcurrentTuning();
            if (activeTuningOperations.size() < maxConcurrent) {
                activeTuningOperations.put(pos, operation);
                if (client.field_1724 != null) {
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.AUTO_TUNING_STARTED, (Object[])new Object[]{NoteBlockTuner.posToString(pos), note}), true);
                }
            } else {
                tuningQueue.offer(operation);
                if (client.field_1724 != null) {
                    int queuePosition = tuningQueue.size();
                    client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.QUEUED_FOR_TUNING, (Object[])new Object[]{NoteBlockTuner.posToString(pos), note, queuePosition}), true);
                }
            }
        }
    }

    public static void stopAllAutoTuning() {
        int stoppedActive = activeTuningOperations.size();
        int stoppedQueued = tuningQueue.size();
        activeTuningOperations.clear();
        tuningQueue.clear();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            int total = stoppedActive + stoppedQueued;
            if (total > 0) {
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)NoteBlockTunerMod.STOPPED_ALL_TUNING, (Object[])new Object[]{stoppedActive, stoppedQueued}), true);
            } else {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)NoteBlockTunerMod.NO_TUNING_OPERATIONS_TO_STOP), true);
            }
        }
    }

    private static int calculateDelay(@NotNull class_310 client, TuningOperation operation) {
        class_2680 state;
        if (client.field_1687 != null && (state = client.field_1687.method_8320(operation.pos)).method_26204() == class_2246.field_10179) {
            int currentNote = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            int distance = Math.abs(currentNote - operation.targetNote);
            if (distance <= 2) {
                return 5 + (distance == 0 ? 1 : 0);
            }
            if (distance <= 5) {
                return 3 + (distance == 3 ? 1 : 0);
            }
            return NoteBlockTunerMod.getConfig().getNoteBlockDelay() + (distance > 10 ? 1 : 0);
        }
        return 5;
    }

    public static boolean isPositionBeingTuned(class_2338 pos) {
        return activeTuningOperations.containsKey(pos) || tuningQueue.stream().anyMatch(op -> op.pos.equals((Object)pos));
    }

    @NotNull
    private static String posToString(@NotNull class_2338 pos) {
        return "(" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + ")";
    }

    private static class TuningOperation {
        final class_2338 pos;
        final int targetNote;
        final int originalNote;
        int currentTicks;

        TuningOperation(class_2338 pos, int targetNote, int originalNote) {
            this.pos = pos;
            this.targetNote = targetNote;
            this.originalNote = originalNote;
            this.currentTicks = 0;
        }
    }
}

