/*
 * Decompiled with CFR 0.152.
 */
package net.a5ho9999.noteblocktuner.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.a5ho9999.noteblocktuner.NoteBlockTunerMod;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "noteblocktuner.json");
    private int noteBlockDelay = 1;
    private int concurrentTuning = 3;
    private boolean openAfterPlace = false;
    private boolean displayColours = true;

    public int getNoteBlockDelay() {
        return this.noteBlockDelay;
    }

    public void setNoteBlockDelay(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 20) {
            value = 20;
        }
        this.noteBlockDelay = value;
    }

    public int getConcurrentTuning() {
        return this.concurrentTuning;
    }

    public void setConcurrentTuning(int value) {
        if (value <= 0) {
            value = 1;
        } else if (value > 5) {
            value = 5;
        }
        this.concurrentTuning = value;
    }

    public boolean getAfterPlace() {
        return this.openAfterPlace;
    }

    public void setAfterPlace(boolean value) {
        this.openAfterPlace = value;
    }

    public boolean getDisplayColours() {
        return this.displayColours;
    }

    public void setDisplayColours(boolean value) {
        this.displayColours = value;
    }

    public static ModConfig load() {
        ModConfig config;
        block8: {
            config = new ModConfig();
            try {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                File configFile = CONFIG_PATH.toFile();
                if (configFile.exists()) {
                    try (FileReader reader = new FileReader(configFile);){
                        config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                        NoteBlockTunerMod.onLog("Config loaded successfully", new Object[0]);
                        break block8;
                    }
                }
                config.save();
                NoteBlockTunerMod.onLog("Created default config", new Object[0]);
            }
            catch (IOException e) {
                NoteBlockTunerMod.onLog("Failed to load config", e);
            }
        }
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_PATH.toFile());){
                GSON.toJson((Object)this, (Appendable)writer);
                NoteBlockTunerMod.onLog("Config saved successfully", new Object[0]);
            }
        }
        catch (IOException e) {
            NoteBlockTunerMod.onLog("Failed to save config", e);
        }
    }

    public void validate() throws IOException {
        try {
            this.setNoteBlockDelay(this.noteBlockDelay);
            this.setConcurrentTuning(this.concurrentTuning);
            this.save();
        }
        catch (Exception ex) {
            NoteBlockTunerMod.onLog("Failed to validate and save config - {}", ex);
            throw new IOException("Config validation failed", ex);
        }
    }
}

