/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.registry.TooltipRegistries;
import dev.obscuria.tooltips.client.tooltip.TooltipStyle;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import net.minecraft.world.item.ItemStack;

public record TooltipDefinition(int priority, TooltipStyle style, ItemFilter filter) implements Comparable<TooltipDefinition>
{
    public static final Codec<TooltipDefinition> DIRECT_CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("priority").forGetter(TooltipDefinition::priority), (App)TooltipStyle.CODEC.fieldOf("style").forGetter(TooltipDefinition::style), (App)ItemFilter.CODEC.fieldOf("filter").forGetter(TooltipDefinition::filter)).apply((Applicative)codec, TooltipDefinition::new));

    public boolean isFor(ItemStack stack) {
        return this.filter.test(stack);
    }

    @Override
    public int compareTo(TooltipDefinition other) {
        return Integer.compare(this.priority, other.priority);
    }

    public static TooltipStyle aggregateStyleFor(ItemStack stack) {
        TooltipStyle style = TooltipStyle.EMPTY;
        for (TooltipDefinition definition : TooltipRegistries.Resource.TOOLTIP_DEFINITION.listElements()) {
            if (!definition.isFor(stack)) continue;
            style = style.merge(definition.style);
        }
        return style;
    }
}

