/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import dev.obscuria.tooltips.client.ParticleData;
import dev.obscuria.tooltips.client.component.BlankComponent;
import dev.obscuria.tooltips.client.tooltip.TooltipDefinition;
import dev.obscuria.tooltips.client.tooltip.TooltipLabel;
import dev.obscuria.tooltips.client.tooltip.TooltipStyle;
import dev.obscuria.tooltips.client.tooltip.element.SoundTemplate;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

public abstract class TooltipState {
    private static UUID lastIconSoundUuid = UUID.randomUUID();
    private static long lastIconSoundTime = 0L;
    public final class_1799 stack;
    public final TooltipStyle style;
    @Nullable
    public final TooltipLabel label;
    public final Long startTime;
    public final List<ParticleData> particles;
    public final UUID uuid = UUID.randomUUID();
    public boolean isFirstFrame = true;

    protected TooltipState(class_1799 stack) {
        this.stack = stack;
        this.style = TooltipDefinition.aggregateStyleFor(stack);
        this.label = TooltipLabel.findFor(stack);
        this.startTime = class_156.method_658();
        this.particles = new ArrayList<ParticleData>();
    }

    public boolean isInitialFrame() {
        return class_156.method_658() == this.startTime;
    }

    public float timeInSeconds() {
        return (float)(class_156.method_658() - this.startTime) * 0.001f;
    }

    public class_5684 createLabel() {
        return this.label != null ? this.label.create(this.stack) : BlankComponent.INSTANCE;
    }

    public void addParticle(ParticleData particle) {
        this.particles.add(particle);
    }

    public void maybePlayIconSound(SoundTemplate template) {
        if (!((Boolean)ClientConfig.SOUNDS_ENABLED.get()).booleanValue()) {
            return;
        }
        if (this.uuid.equals(lastIconSoundUuid)) {
            return;
        }
        if (class_156.method_658() - this.startTime < 100L) {
            return;
        }
        if (class_156.method_658() - lastIconSoundTime < 300L) {
            return;
        }
        lastIconSoundTime = class_156.method_658();
        lastIconSoundUuid = this.uuid;
        template.play();
    }

    public void renderPanel(class_332 graphics, Vector2ic pos, int width, int height) {
        if (this.style.panel().isEmpty()) {
            return;
        }
        this.style.panel().get().render(graphics, pos.x(), pos.y(), width, height);
    }

    public void renderEffects(class_332 graphics, Vector2ic pos, int width, int height) {
        for (TooltipEffect effect : this.style.effects()) {
            effect.renderBack(this, graphics, pos.x(), pos.y(), width, height);
        }
    }

    public void renderFrame(class_332 graphics, Vector2ic pos, int width, int height) {
        if (this.style.frame().isEmpty()) {
            return;
        }
        this.style.frame().get().render(graphics, pos.x(), pos.y(), width, height);
    }

    public void update() {
        this.particles.removeIf(ParticleData::isExpired);
        this.isFirstFrame = false;
    }
}

