/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.fragmentum.util.easing.EasingFunction;
import dev.obscuria.tooltips.ObscureTooltips;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_7833;

public record RayGlowEffect(ARGB primaryColor, ARGB secondaryColor) implements TooltipEffect
{
    public static final class_2960 TEXTURE = ObscureTooltips.key("textures/gui/effect/ray_glow.png");
    public static final Codec<RayGlowEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGB.CODEC.fieldOf("primary_color").forGetter(RayGlowEffect::primaryColor), (App)ARGB.CODEC.fieldOf("secondary_color").forGetter(RayGlowEffect::secondaryColor)).apply((Applicative)codec, RayGlowEffect::new));

    public Codec<RayGlowEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof RayGlowEffect);
    }

    @Override
    public void renderIcon(TooltipState state, class_332 graphics, int x, int y) {
        float time = state.timeInSeconds();
        float base = class_3532.method_15363((float)Easing.EASE_OUT_CUBIC.compute(time / 0.5f), (float)0.0f, (float)1.0f);
        float scale = base + 0.75f * Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_OUT_CUBIC, 0.25f).compute(time);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        GraphicUtils.setShaderColor(this.primaryColor);
        this.renderSegment(graphics, x, y, 1.0f * scale, 0.5f, time);
        GraphicUtils.setShaderColor(this.primaryColor.lerp(this.secondaryColor, 0.5f));
        this.renderSegment(graphics, x, y, 0.75f * scale, -0.33f, time);
        GraphicUtils.setShaderColor(this.secondaryColor);
        this.renderSegment(graphics, x, y, 0.5f * scale, 0.25f, time);
        GraphicUtils.resetShaderColor();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    private void renderSegment(class_332 graphics, int x, int y, float scale, float rotDelta, float timer) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(scale, scale, scale);
        graphics.method_51448().method_22907(class_7833.field_40718.rotation(rotDelta * 3.0f + rotDelta * timer));
        graphics.method_25290(TEXTURE, -32, -32, 0.0f, 0.0f, 64, 64, 64, 64);
        graphics.method_51448().method_22909();
    }
}

