/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import org.jetbrains.annotations.Nullable;

public record NbtFilter(class_2487 nbt, boolean matchExact) implements ItemFilter
{
    public static final Codec<NbtFilter> CODEC;

    public Codec<NbtFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(class_1799 stack) {
        return this.matchExact ? class_2512.method_10687((class_2520)this.nbt, (class_2520)stack.method_7969(), (boolean)true) : NbtFilter.isSubtagOf((class_2520)this.nbt, (class_2520)stack.method_7969());
    }

    private static DataResult<class_2487> tryParseNbt(String input) {
        try {
            return DataResult.success((Object)class_2522.method_10718((String)input));
        }
        catch (CommandSyntaxException exception) {
            return DataResult.error(() -> "Invalid tag: " + exception.getMessage());
        }
    }

    private static boolean isSubtagOf(@Nullable class_2520 tag, @Nullable class_2520 parent) {
        if (tag == null) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        if (tag.method_10711() != parent.method_10711()) {
            return false;
        }
        if (tag instanceof class_2487) {
            class_2487 compound1 = (class_2487)tag;
            if (parent instanceof class_2487) {
                class_2487 compound2 = (class_2487)parent;
                for (String key : compound1.method_10541()) {
                    class_2520 sub2;
                    class_2520 sub1 = compound1.method_10580(key);
                    if (NbtFilter.isSubtagOf(sub1, sub2 = compound2.method_10580(key))) continue;
                    return false;
                }
                return true;
            }
        }
        if (tag instanceof class_2499) {
            class_2499 list1 = (class_2499)tag;
            if (parent instanceof class_2499) {
                class_2499 list2 = (class_2499)parent;
                if (list1.size() > list2.size()) {
                    return false;
                }
                for (class_2520 element1 : list1) {
                    boolean found = false;
                    for (class_2520 element2 : list2) {
                        if (!NbtFilter.isSubtagOf(element1, element2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
        }
        return tag.equals(parent);
    }

    static {
        Codec tagCodec = Codec.STRING.comapFlatMap(NbtFilter::tryParseNbt, class_2487::toString);
        CODEC = RecordCodecBuilder.create(codec -> codec.group((App)tagCodec.fieldOf("nbt").forGetter(NbtFilter::nbt), (App)Codec.BOOL.optionalFieldOf("match_exact", (Object)false).forGetter(NbtFilter::matchExact)).apply((Applicative)codec, NbtFilter::new));
    }
}

