/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import dev.obscuria.fragmentum.client.ClientGroupTooltip;
import dev.obscuria.tooltips.client.TooltipHelper;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.StackBuffer;
import dev.obscuria.tooltips.client.tooltip.TooltipScroll;
import dev.obscuria.tooltips.client.tooltip.layout.ArmorPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.DefaultLayout;
import dev.obscuria.tooltips.client.tooltip.layout.ToolPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.TooltipLayout;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import org.joml.Vector2ic;

public final class TooltipRenderer {
    private static ItemStack lastStack = ItemStack.EMPTY;
    private static ItemStack actualStack = ItemStack.EMPTY;
    private static TooltipLayout<?> layout = new DefaultLayout();
    private static TooltipState state = new EmptyState();

    public static boolean render(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        if (!((Boolean)ClientConfig.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (components.isEmpty()) {
            return false;
        }
        if (!TooltipRenderer.perform(components)) {
            return false;
        }
        components = new ArrayList<ClientTooltipComponent>(components);
        components = layout.rawProcessPreWrap(state, components, font);
        components = TooltipHelper.wrapLines(graphics, components, font);
        components = layout.rawProcessPostWrap(state, components, font);
        int margin = (Integer)ClientConfig.CONTENT_MARGIN.get();
        int width = margin * 2 + TooltipHelper.widthOf(components, font);
        int height = margin * 2 + TooltipHelper.heightOf(components) - 2;
        Vector2ic pos = positioner.positionTooltip(graphics.guiWidth(), graphics.guiHeight(), mouseX, mouseY, width, height);
        TooltipScroll.update(state, 6 + height, graphics.guiHeight());
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, TooltipScroll.getScroll(), 400.0f);
        graphics.flush();
        state.renderPanel(graphics, pos, width, height);
        state.renderEffects(graphics, pos, width, height);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 2.0f);
        state.renderFrame(graphics, pos, width, height);
        graphics.pose().popPose();
        graphics.flush();
        int componentX = margin + pos.x();
        int componentY = margin + pos.y();
        for (ClientTooltipComponent component : components) {
            component.renderText(font, componentX, componentY, graphics.pose().last().pose(), graphics.bufferSource());
            component.renderImage(font, componentX, componentY, graphics);
            componentY += component.getHeight();
        }
        graphics.pose().popPose();
        lastStack = actualStack;
        actualStack = ItemStack.EMPTY;
        state.removeExpiredParticles();
        return true;
    }

    private static boolean perform(List<ClientTooltipComponent> components) {
        StackBuffer buffer = (StackBuffer)ClientGroupTooltip.findFirst(components, StackBuffer.class);
        if (buffer == null) {
            return false;
        }
        actualStack = buffer.stack();
        if (ItemStack.isSameItemSameComponents((ItemStack)lastStack, (ItemStack)actualStack)) {
            return true;
        }
        layout = TooltipRenderer.shouldShowArmorPreview(actualStack) ? ArmorPreviewLayout.INSTANCE : (TooltipRenderer.shouldShowToolPreview(actualStack) ? ToolPreviewLayout.INSTANCE : DefaultLayout.INSTANCE);
        state = layout.extractState(actualStack);
        return true;
    }

    private static boolean shouldShowArmorPreview(ItemStack stack) {
        if (!((Boolean)ClientConfig.ARMOR_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInArmorPreviewBlacklist(stack.getItem())) {
            return false;
        }
        return stack.getItem() instanceof ArmorItem || ClientConfig.isInArmorPreviewWhitelist(stack.getItem());
    }

    private static boolean shouldShowToolPreview(ItemStack stack) {
        if (!((Boolean)ClientConfig.TOOL_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInToolPreviewBlacklist(stack.getItem())) {
            return false;
        }
        return stack.getItem() instanceof TieredItem || ClientConfig.isInToolPreviewWhitelist(stack.getItem());
    }

    private static final class EmptyState
    extends TooltipState {
        private EmptyState() {
            super(ItemStack.EMPTY);
        }
    }
}

