/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.icon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.content.util.easing.Easing;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.Transform;
import dev.obscuria.tooltips.client.tooltip.element.icon.TooltipIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public record AccentBurstIcon(Transform transform) implements TooltipIcon
{
    public static final MapCodec<AccentBurstIcon> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Transform.CODEC.fieldOf("transform").forGetter(AccentBurstIcon::transform)).apply((Applicative)codec, AccentBurstIcon::new));

    public MapCodec<AccentBurstIcon> codec() {
        return CODEC;
    }

    @Override
    public void render(TooltipState state, GuiGraphics graphics, int x, int y) {
        this.pushTransform(state, this.transform, graphics, x, y);
        graphics.renderItem(state.stack, 0, 0);
        this.popTransform(graphics);
    }

    @Override
    public void applyScale(TooltipState state, GuiGraphics graphics, int x, int y) {
        float time = state.timeInSeconds();
        float scale = time < 0.25f ? Easing.EASE_OUT_CUBIC.compute(time / 0.25f) * 1.75f : (time < 0.5f ? 1.75f - 0.75f * Easing.EASE_OUT_BACK.compute((time - 0.25f) / 0.25f) : 1.0f);
        graphics.pose().scale(scale, scale, scale);
    }

    @Override
    public void applyRotation(TooltipState state, GuiGraphics graphics, int x, int y) {
        float rotation = 360.0f * Mth.clamp((float)Easing.EASE_OUT_EXPO.compute(state.timeInSeconds()), (float)0.0f, (float)1.0f);
        graphics.pose().mulPose(Axis.YP.rotationDegrees(rotation));
    }
}

