/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.icon;

import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.obscuria.fragmentum.content.registry.BootstrapContext;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.registry.TooltipRegistries;
import dev.obscuria.tooltips.client.tooltip.element.Transform;
import dev.obscuria.tooltips.client.tooltip.element.icon.AccentBurstIcon;
import dev.obscuria.tooltips.client.tooltip.element.icon.AccentIcon;
import dev.obscuria.tooltips.client.tooltip.element.icon.AccentSpinIcon;
import dev.obscuria.tooltips.client.tooltip.element.icon.StaticIcon;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;

public interface TooltipIcon {
    public static final Codec<TooltipIcon> DIRECT_CODEC = TooltipRegistries.TOOLTIP_ICON_TYPE.byNameCodec().dispatch(TooltipIcon::codec, Function.identity());
    public static final Codec<TooltipIcon> CODEC = TooltipRegistries.Resource.TOOLTIP_ICON.byNameCodec();

    public MapCodec<? extends TooltipIcon> codec();

    public void render(TooltipState var1, GuiGraphics var2, int var3, int var4);

    default public void pushTransform(TooltipState state, Transform transform, GuiGraphics graphics, int x, int y) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 150.0f);
        graphics.pose().translate(transform.offset().x, transform.offset().y, transform.offset().z);
        graphics.pose().scale(transform.scale(), transform.scale(), transform.scale());
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(transform.rotation()));
        this.applyScale(state, graphics, x, y);
        this.applyRotation(state, graphics, x, y);
        graphics.pose().pushPose();
        graphics.pose().translate(-8.0f, -8.0f, -150.0f);
    }

    default public void popTransform(GuiGraphics graphics) {
        graphics.pose().popPose();
        graphics.pose().popPose();
    }

    default public void applyScale(TooltipState state, GuiGraphics graphics, int x, int y) {
    }

    default public void applyRotation(TooltipState state, GuiGraphics graphics, int x, int y) {
    }

    public static void bootstrap(BootstrapContext<MapCodec<? extends TooltipIcon>> context) {
        context.register("static", () -> StaticIcon.CODEC);
        context.register("accent", () -> AccentIcon.CODEC);
        context.register("accent_spin", () -> AccentSpinIcon.CODEC);
        context.register("accent_burst", () -> AccentBurstIcon.CODEC);
    }
}

