/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.layout;

import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.HeaderComponent;
import dev.obscuria.tooltips.client.tooltip.layout.TooltipLayout;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public abstract class AbstractHeaderLayout<T extends TooltipState>
implements TooltipLayout<T> {
    @Override
    public List<ClientTooltipComponent> processPreWrap(T state, List<ClientTooltipComponent> components, Font font) {
        this.makeHeader(state, components, font);
        return components;
    }

    protected void makeHeader(T state, List<ClientTooltipComponent> components, Font font) {
        ClientTooltipComponent title = components.removeFirst();
        ClientTooltipComponent label = ((TooltipState)state).createLabel();
        boolean drawDelimiter = !components.isEmpty() && !this.isZeroHeight(components);
        components.addFirst(new HeaderComponent(drawDelimiter, (TooltipState)state, title, label));
    }

    private boolean isZeroHeight(List<ClientTooltipComponent> components) {
        return components.stream().mapToInt(ClientTooltipComponent::getHeight).sum() <= 0;
    }
}

