/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.layout;

import com.mojang.serialization.MapCodec;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.ArmorPreviewComponent;
import dev.obscuria.tooltips.client.component.SplitComponent;
import dev.obscuria.tooltips.client.tooltip.layout.AbstractHeaderLayout;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ArmorPreviewLayout
extends AbstractHeaderLayout<State> {
    public static final ArmorPreviewLayout INSTANCE = new ArmorPreviewLayout();
    public static final MapCodec<ArmorPreviewLayout> CODEC = MapCodec.unit((Object)INSTANCE);

    @Override
    public MapCodec<ArmorPreviewLayout> codec() {
        return CODEC;
    }

    @Override
    public State extractState(ItemStack stack) {
        return new State(stack);
    }

    @Override
    public List<ClientTooltipComponent> processPostWrap(State state, List<ClientTooltipComponent> components, Font font) {
        if (state.armorStand == null) {
            return components;
        }
        return List.of(new SplitComponent(new ArmorPreviewComponent(state.armorStand), components));
    }

    public static class State
    extends TooltipState {
        @Nullable
        public final ArmorStand armorStand;

        protected State(ItemStack stack) {
            super(stack);
            this.armorStand = this.makeArmorStand(stack);
        }

        @Nullable
        private ArmorStand makeArmorStand(ItemStack stack) {
            if (Minecraft.getInstance().level == null) {
                return null;
            }
            ArmorStand armorStand = new ArmorStand(EntityType.ARMOR_STAND, (Level)Minecraft.getInstance().level);
            Item item = stack.getItem();
            if (!(item instanceof ArmorItem)) {
                return armorStand;
            }
            ArmorItem armorItem = (ArmorItem)item;
            armorStand.setItemSlot(armorItem.getEquipmentSlot(), stack);
            return armorStand;
        }
    }
}

