/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.component;

import dev.obscuria.fragmentum.content.util.color.ARGB;
import dev.obscuria.fragmentum.content.util.color.Colors;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.BlankComponent;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import dev.obscuria.tooltips.config.ClientConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public record HeaderComponent(boolean drawDelimiter, TooltipState state, ClientTooltipComponent title, ClientTooltipComponent label) implements ClientTooltipComponent
{
    private static final ARGB SEPARATOR_EDGE = Colors.argbOf((int)0xFFFFFF);
    private static final ARGB SEPARATOR_CENTER = Colors.argbOf((int)0x60FFFFFF);

    public int getHeight() {
        return this.drawDelimiter ? 25 : 22;
    }

    public int getWidth(Font font) {
        return 22 + Math.max(this.title.getWidth(font), this.label.getWidth(font));
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource source) {
        if (!((Boolean)ClientConfig.LABELS_ENABLED.get()).booleanValue() || this.label instanceof BlankComponent) {
            this.title.renderText(font, 22 + x, 1 + y + 5, matrix, source);
        } else {
            this.title.renderText(font, 22 + x, 1 + y, matrix, source);
            this.label.renderText(font, 22 + x, 1 + y + this.title.getHeight(), matrix, source);
        }
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        this.state.style.slot().ifPresent(it -> it.render(graphics, x, y, 20, 20));
        this.state.style.effects().forEach(it -> it.renderIcon(this.state, graphics, x + 10, y + 10));
        this.state.style.icon().ifPresent(it -> it.render(this.state, graphics, x + 10, y + 10));
        if (!this.drawDelimiter) {
            return;
        }
        int length = this.getWidth(font) / 2;
        GraphicUtils.drawHLine(graphics, x, y + 22, length, SEPARATOR_EDGE, SEPARATOR_CENTER);
        GraphicUtils.drawHLine(graphics, x + length, y + 22, 1 + length, SEPARATOR_CENTER, SEPARATOR_EDGE);
    }
}

