/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.layout;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.obscuria.fragmentum.content.registry.BootstrapContext;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.registry.TooltipRegistries;
import dev.obscuria.tooltips.client.tooltip.element.panel.TooltipPanel;
import dev.obscuria.tooltips.client.tooltip.layout.ArmorPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.DefaultLayout;
import dev.obscuria.tooltips.client.tooltip.layout.ToolPreviewLayout;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;

public interface TooltipLayout<T extends TooltipState> {
    public static final Codec<TooltipPanel> DIRECT_CODEC = TooltipRegistries.TOOLTIP_PANEL_TYPE.byNameCodec().dispatch(TooltipPanel::codec, Function.identity());

    public MapCodec<? extends TooltipLayout<?>> codec();

    public T extractState(ItemStack var1);

    public List<ClientTooltipComponent> processPreWrap(T var1, List<ClientTooltipComponent> var2, Font var3);

    public List<ClientTooltipComponent> processPostWrap(T var1, List<ClientTooltipComponent> var2, Font var3);

    default public List<ClientTooltipComponent> rawProcessPreWrap(TooltipState state, List<ClientTooltipComponent> components, Font font) {
        return this.processPreWrap(this.adapt(state), components, font);
    }

    default public List<ClientTooltipComponent> rawProcessPostWrap(TooltipState state, List<ClientTooltipComponent> components, Font font) {
        return this.processPostWrap(this.adapt(state), components, font);
    }

    default public T adapt(TooltipState state) {
        return (T)state;
    }

    public static void bootstrap(BootstrapContext<MapCodec<? extends TooltipLayout<?>>> context) {
        context.register("default", () -> DefaultLayout.CODEC);
        context.register("armor_preview", () -> ArmorPreviewLayout.CODEC);
        context.register("tool_preview", () -> ToolPreviewLayout.CODEC);
    }
}

