/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.ParticleData;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.Transform;
import dev.obscuria.tooltips.client.tooltip.particle.TooltipParticle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public record TextureParticle(ResourceLocation texture, Transform transform) implements TooltipParticle
{
    public static final MapCodec<TextureParticle> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(TextureParticle::texture), (App)Transform.CODEC.optionalFieldOf("transform", (Object)Transform.DEFAULT).forGetter(TextureParticle::transform)).apply((Applicative)codec, TextureParticle::new));

    public MapCodec<TextureParticle> codec() {
        return CODEC;
    }

    @Override
    public void render(GuiGraphics graphics, TooltipState state, ParticleData data) {
        graphics.pose().pushPose();
        this.transform.apply(graphics);
        graphics.blit(this.texture, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.pose().popPose();
    }
}

