/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip;

import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.config.ClientConfig;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public final class TooltipScroll {
    private static float scroll;
    private static boolean isActive;
    private static int maxScroll;
    private static float startScroll;
    private static float endScroll;
    private static long lastInputTime;
    private static long lastUpdateTime;

    public static boolean shouldCaptureInput() {
        if (!((Boolean)ClientConfig.SCROLL_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!isActive || lastUpdateTime == 0L) {
            return false;
        }
        return Util.m_137550_() - lastUpdateTime <= 200L;
    }

    public static void onInput(float offset) {
        float scrollSpeed = ((Integer)ClientConfig.SCROLL_SPEED.get()).intValue();
        float targetScroll = TooltipScroll.clampScroll(endScroll + offset * scrollSpeed);
        if (endScroll == targetScroll) {
            return;
        }
        lastInputTime = Util.m_137550_();
        startScroll = scroll;
        endScroll = targetScroll;
    }

    public static void update(TooltipState state, int tooltipHeight, int screenHeight) {
        if (!((Boolean)ClientConfig.SCROLL_ENABLED.get()).booleanValue()) {
            return;
        }
        int overflow = Math.max(0, tooltipHeight - Math.max(0, screenHeight));
        boolean bl = isActive = overflow > 0;
        if (isActive) {
            TooltipScroll.maybeSetup(state, overflow);
            long currentTime = Util.m_137550_();
            float scrollProgress = (float)(currentTime - lastInputTime) / 100.0f;
            float scrollDelta = Easing.EASE_OUT_CUBIC.compute(Math.min(1.0f, scrollProgress));
            scroll = Mth.m_14179_((float)scrollDelta, (float)startScroll, (float)endScroll);
            lastUpdateTime = currentTime;
        } else {
            scroll = 0.0f;
            maxScroll = 0;
            startScroll = 0.0f;
            endScroll = 0.0f;
            lastUpdateTime = 0L;
        }
    }

    private static void maybeSetup(TooltipState state, int overflow) {
        if (!state.isInitialFrame() && maxScroll == overflow) {
            return;
        }
        lastUpdateTime = Util.m_137550_();
        maxScroll = overflow;
        startScroll = scroll = TooltipScroll.maxScroll();
        endScroll = scroll;
    }

    private static float minScroll() {
        return -((Integer)ClientConfig.SCROLL_MARGIN.get()).intValue();
    }

    private static float maxScroll() {
        return maxScroll + (Integer)ClientConfig.SCROLL_MARGIN.get();
    }

    private static float clampScroll(float scroll) {
        return Mth.m_14036_((float)scroll, (float)TooltipScroll.minScroll(), (float)TooltipScroll.maxScroll());
    }

    @Generated
    public static float getScroll() {
        return scroll;
    }
}

