/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.icon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.easing.Easing;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.Transform;
import dev.obscuria.tooltips.client.tooltip.element.icon.TooltipIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public record AccentSpinIcon(Transform transform) implements TooltipIcon
{
    public static final Codec<AccentSpinIcon> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Transform.CODEC.fieldOf("transform").forGetter(AccentSpinIcon::transform)).apply((Applicative)codec, AccentSpinIcon::new));

    public Codec<AccentSpinIcon> codec() {
        return CODEC;
    }

    @Override
    public void render(TooltipState state, GuiGraphics graphics, int x, int y) {
        this.pushTransform(state, this.transform, graphics, x, y);
        graphics.m_280480_(state.stack, 0, 0);
        this.popTransform(graphics);
    }

    @Override
    public void applyScale(TooltipState state, GuiGraphics graphics, int x, int y) {
        float time = state.timeInSeconds();
        float scale = time < 0.25f ? Easing.EASE_OUT_CUBIC.compute(time / 0.25f) * 1.33f : (time < 0.5f ? 1.33f - 0.33f * Easing.EASE_OUT_CUBIC.compute((time - 0.25f) / 0.25f) : 1.0f);
        graphics.m_280168_().m_85841_(scale, scale, scale);
    }

    @Override
    public void applyRotation(TooltipState state, GuiGraphics graphics, int x, int y) {
        float rotation = 360.0f * Mth.m_14036_((float)Easing.EASE_OUT_EXPO.compute(state.timeInSeconds()), (float)0.0f, (float)1.0f);
        graphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotation));
    }
}

