/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import dev.obscuria.fragmentum.client.ClientGroupTooltip;
import dev.obscuria.tooltips.client.TooltipHelper;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.component.StackBuffer;
import dev.obscuria.tooltips.client.tooltip.TooltipScroll;
import dev.obscuria.tooltips.client.tooltip.layout.ArmorPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.DefaultLayout;
import dev.obscuria.tooltips.client.tooltip.layout.ToolPreviewLayout;
import dev.obscuria.tooltips.client.tooltip.layout.TooltipLayout;
import dev.obscuria.tooltips.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import org.joml.Vector2ic;

public final class TooltipRenderer {
    private static ItemStack lastStack = ItemStack.f_41583_;
    private static ItemStack actualStack = ItemStack.f_41583_;
    private static TooltipLayout<?> layout = new DefaultLayout();
    private static TooltipState state = new EmptyState();

    public static boolean render(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        if (!((Boolean)ClientConfig.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (components.isEmpty()) {
            return false;
        }
        if (!TooltipRenderer.perform(components)) {
            return false;
        }
        components = new ArrayList<ClientTooltipComponent>(components);
        components = layout.rawProcessPreWrap(state, components, font);
        components = TooltipHelper.wrapLines(graphics, components, font);
        components = layout.rawProcessPostWrap(state, components, font);
        Integer margin = (Integer)ClientConfig.CONTENT_MARGIN.get();
        int width = margin * 2 + TooltipHelper.widthOf(components, font);
        int height = margin * 2 + TooltipHelper.heightOf(components) - 2;
        Vector2ic pos = positioner.m_262814_(graphics.m_280182_(), graphics.m_280206_(), mouseX, mouseY, width, height);
        TooltipScroll.update(state, 6 + height, graphics.m_280206_());
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, TooltipScroll.getScroll(), 400.0f);
        graphics.m_280262_();
        state.renderPanel(graphics, pos, width, height);
        state.renderEffects(graphics, pos, width, height);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        state.renderFrame(graphics, pos, width, height);
        graphics.m_280168_().m_85849_();
        graphics.m_280262_();
        int componentX = margin + pos.x();
        int componentY = margin + pos.y();
        for (ClientTooltipComponent component : components) {
            component.m_142440_(font, componentX, componentY, graphics.m_280168_().m_85850_().m_252922_(), graphics.m_280091_());
            component.m_183452_(font, componentX, componentY, graphics);
            componentY += component.m_142103_();
        }
        graphics.m_280168_().m_85849_();
        lastStack = actualStack;
        actualStack = ItemStack.f_41583_;
        state.removeExpiredParticles();
        return true;
    }

    private static boolean perform(List<ClientTooltipComponent> components) {
        StackBuffer buffer = (StackBuffer)ClientGroupTooltip.findFirst(components, StackBuffer.class);
        if (buffer == null) {
            return false;
        }
        actualStack = buffer.stack();
        if (ItemStack.m_150942_((ItemStack)lastStack, (ItemStack)actualStack)) {
            return true;
        }
        layout = TooltipRenderer.shouldShowArmorPreview(actualStack) ? ArmorPreviewLayout.INSTANCE : (TooltipRenderer.shouldShowToolPreview(actualStack) ? ToolPreviewLayout.INSTANCE : DefaultLayout.INSTANCE);
        state = layout.extractState(actualStack);
        return true;
    }

    private static boolean shouldShowArmorPreview(ItemStack stack) {
        if (!((Boolean)ClientConfig.ARMOR_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInArmorPreviewBlacklist(stack.m_41720_())) {
            return false;
        }
        return stack.m_41720_() instanceof ArmorItem || ClientConfig.isInArmorPreviewWhitelist(stack.m_41720_());
    }

    private static boolean shouldShowToolPreview(ItemStack stack) {
        if (!((Boolean)ClientConfig.TOOL_PREVIEW_ENABLED.get()).booleanValue()) {
            return false;
        }
        if (ClientConfig.isInToolPreviewBlacklist(stack.m_41720_())) {
            return false;
        }
        return stack.m_41720_() instanceof TieredItem || ClientConfig.isInToolPreviewWhitelist(stack.m_41720_());
    }

    private static final class EmptyState
    extends TooltipState {
        private EmptyState() {
            super(ItemStack.f_41583_);
        }
    }
}

