/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public record ShimmerEffect(ARGB innerColor, ARGB accentColor, ARGB outerColor, float frequency, float speed) implements TooltipEffect
{
    public static final Codec<ShimmerEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGB.CODEC.fieldOf("inner_color").forGetter(ShimmerEffect::innerColor), (App)ARGB.CODEC.fieldOf("accent_color").forGetter(ShimmerEffect::accentColor), (App)ARGB.CODEC.fieldOf("outer_color").forGetter(ShimmerEffect::outerColor), (App)Codec.FLOAT.fieldOf("frequency").forGetter(ShimmerEffect::frequency), (App)Codec.FLOAT.fieldOf("speed").forGetter(ShimmerEffect::speed)).apply((Applicative)codec, ShimmerEffect::new));

    public Codec<ShimmerEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof ShimmerEffect);
    }

    @Override
    public void renderBack(TooltipState state, GuiGraphics graphics, int x, int y, int width, int height) {
        int actX = x - 3;
        int actY = y - 3;
        int actWidth = width + 6;
        int actHeight = height + 6;
        float ctrlWidth = (float)actWidth - 24.0f;
        float ctrlHeight = (float)actHeight - 24.0f;
        float ctrlLeft = (float)actX + 12.0f;
        float ctrlTop = (float)actY + 12.0f;
        float ctrlRight = ctrlLeft + ctrlWidth;
        float CtrlBottom = ctrlTop + ctrlHeight;
        Vector2f ctrlCenter = new Vector2f(ctrlLeft + ctrlWidth * 0.5f, ctrlTop + ctrlHeight * 0.5f);
        int wSegments = 32;
        int hSegments = Math.max(1, (int)(32.0f * ((float)actHeight / (float)actWidth)));
        Vector2f control1 = new Vector2f();
        Vector2f control2 = new Vector2f();
        Vector2f inner1 = new Vector2f();
        Vector2f inner2 = new Vector2f();
        Vector2f outer1 = new Vector2f();
        Vector2f outer2 = new Vector2f();
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer buffer = graphics.m_280091_().m_6299_(RenderType.m_286086_());
        float time = state.timeInSeconds();
        this.renderSide(32, i -> inner1.set((float)actX + (float)actWidth * (float)i / 32.0f, (float)actY), i -> inner2.set((float)actX + (float)actWidth * (float)(i + 1) / 32.0f, (float)actY), i -> control1.set(ctrlLeft + ctrlWidth * (float)i / 32.0f, ctrlTop), i -> control2.set(ctrlLeft + ctrlWidth * (float)(i + 1) / 32.0f, ctrlTop), false, ctrlCenter, time, matrix, buffer, inner1, inner2, control1, control2, outer1, outer2);
        this.renderSide(32, i -> inner1.set((float)actX + (float)actWidth * (float)(i + 1) / 32.0f, (float)(actY + actHeight)), i -> inner2.set((float)actX + (float)actWidth * (float)i / 32.0f, (float)(actY + actHeight)), i -> control1.set(ctrlLeft + ctrlWidth * (float)(i + 1) / 32.0f, CtrlBottom), i -> control2.set(ctrlLeft + ctrlWidth * (float)i / 32.0f, CtrlBottom), false, ctrlCenter, time, matrix, buffer, inner1, inner2, control1, control2, outer1, outer2);
        this.renderSide(hSegments, i -> inner1.set((float)actX, (float)actY + (float)actHeight * (float)i / (float)hSegments), i -> inner2.set((float)actX, (float)actY + (float)actHeight * (float)(i + 1) / (float)hSegments), i -> control1.set(ctrlLeft, ctrlTop + ctrlHeight * (float)i / (float)hSegments), i -> control2.set(ctrlLeft, ctrlTop + ctrlHeight * (float)(i + 1) / (float)hSegments), true, ctrlCenter, time, matrix, buffer, inner1, inner2, control1, control2, outer1, outer2);
        this.renderSide(hSegments, i -> inner1.set((float)(actX + actWidth), (float)actY + (float)actHeight * (float)(i + 1) / (float)hSegments), i -> inner2.set((float)(actX + actWidth), (float)actY + (float)actHeight * (float)i / (float)hSegments), i -> control1.set(ctrlRight, ctrlTop + ctrlHeight * (float)(i + 1) / (float)hSegments), i -> control2.set(ctrlRight, ctrlTop + ctrlHeight * (float)i / (float)hSegments), true, ctrlCenter, time, matrix, buffer, inner1, inner2, control1, control2, outer1, outer2);
    }

    private void renderSide(int segments, IntConsumer inner1Setter, IntConsumer inner2Setter, IntConsumer ctrl1Setter, IntConsumer ctrl2Setter, boolean flip, Vector2f ctrlCenter, float time, Matrix4f matrix, VertexConsumer buffer, Vector2f inner1, Vector2f inner2, Vector2f ctrl1, Vector2f ctrl2, Vector2f outer1, Vector2f outer2) {
        for (int i = 0; i < segments; ++i) {
            inner1Setter.accept(i);
            inner2Setter.accept(i);
            ctrl1Setter.accept(i);
            ctrl2Setter.accept(i);
            float a1 = ctrlCenter.angle((Vector2fc)inner1);
            float a2 = ctrlCenter.angle((Vector2fc)inner2);
            float t1 = 0.5f + 0.5f * (float)Math.cos(a1 * this.frequency + time * this.speed);
            float t2 = 0.5f + 0.5f * (float)Math.cos(a2 * this.frequency + time * this.speed);
            outer1.set((Vector2fc)inner1).lerp((Vector2fc)ctrl1, 0.3f + 0.2f * t1);
            outer2.set((Vector2fc)inner2).lerp((Vector2fc)ctrl2, 0.3f + 0.2f * t2);
            if (flip) {
                GraphicUtils.color(buffer.m_252986_(matrix, inner1.x, inner1.y, 0.0f), this.innerColor.lerp(this.accentColor, t1)).m_5752_();
                GraphicUtils.color(buffer.m_252986_(matrix, inner2.x, inner2.y, 0.0f), this.innerColor.lerp(this.accentColor, t2)).m_5752_();
                GraphicUtils.color(buffer.m_252986_(matrix, outer2.x, outer2.y, 0.0f), this.outerColor).m_5752_();
                GraphicUtils.color(buffer.m_252986_(matrix, outer1.x, outer1.y, 0.0f), this.outerColor).m_5752_();
                continue;
            }
            GraphicUtils.color(buffer.m_252986_(matrix, inner2.x, inner2.y, 0.0f), this.innerColor.lerp(this.accentColor, t2)).m_5752_();
            GraphicUtils.color(buffer.m_252986_(matrix, inner1.x, inner1.y, 0.0f), this.innerColor.lerp(this.accentColor, t1)).m_5752_();
            GraphicUtils.color(buffer.m_252986_(matrix, outer1.x, outer1.y, 0.0f), this.outerColor).m_5752_();
            GraphicUtils.color(buffer.m_252986_(matrix, outer2.x, outer2.y, 0.0f), this.outerColor).m_5752_();
        }
    }
}

