/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import com.mojang.math.Axis;
import dev.obscuria.tooltips.client.ParticleStatus;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.particle.TooltipParticle;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public abstract class ParticleData {
    public final Object source;
    public final float startTime;
    public final Vec2 origin;
    public final Vec2 destination;
    public ParticleStatus status = ParticleStatus.ALIVE;

    public void render(GuiGraphics graphics, TooltipState state, TooltipParticle particle, int x, int y) {
        float progress = this.computeProgress(state);
        Vec2 translation = this.computeTranslation(state, progress);
        float scale = this.computeScale(state, progress);
        float rotation = this.computeRotation(state, progress);
        graphics.pose().pushPose();
        graphics.pose().translate((float)x + this.origin.x + translation.x, (float)y + this.origin.y + translation.y, 0.0f);
        graphics.pose().scale(scale, scale, scale);
        graphics.pose().mulPose(Axis.ZP.rotation(rotation));
        particle.render(graphics, state, this);
        graphics.pose().popPose();
        this.status = progress <= 1.0f ? ParticleStatus.ALIVE : ParticleStatus.EXPIRED;
    }

    public float computeProgress(TooltipState state) {
        return Mth.clamp((float)(state.timeInSeconds() - this.startTime), (float)0.0f, (float)1.0f);
    }

    public Vec2 computeTranslation(TooltipState state, float progress) {
        return new Vec2((this.destination.x - this.origin.x) * progress, (this.destination.y - this.origin.y) * progress);
    }

    public float computeScale(TooltipState state, float progress) {
        return 1.0f;
    }

    public float computeRotation(TooltipState state, float progress) {
        return 0.0f;
    }

    public boolean isExpired() {
        return this.status == ParticleStatus.EXPIRED;
    }

    @Generated
    public ParticleData(Object source, float startTime, Vec2 origin, Vec2 destination) {
        this.source = source;
        this.startTime = startTime;
        this.origin = origin;
        this.destination = destination;
    }
}

