/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.component;

import dev.obscuria.tooltips.client.TooltipHelper;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public record SplitComponent(ClientTooltipComponent left, List<ClientTooltipComponent> right) implements ClientTooltipComponent
{
    public int getHeight() {
        return Math.max(this.left.getHeight(), TooltipHelper.heightOf(this.right));
    }

    public int getWidth(Font font) {
        return this.left.getWidth(font) + 3 + TooltipHelper.widthOf(this.right, font);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int componentX = x + this.left.getWidth(font) + 3;
        int componentY = y;
        for (ClientTooltipComponent component : this.right) {
            component.renderImage(font, componentX, componentY, graphics);
            componentY += component.getHeight();
        }
        this.left.renderImage(font, x, y, graphics);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        int componentX = x + this.left.getWidth(font) + 3;
        int componentY = y;
        for (ClientTooltipComponent component : this.right) {
            component.renderText(font, componentX, componentY, matrix, bufferSource);
            componentY += component.getHeight();
        }
        this.left.renderText(font, x, y, matrix, bufferSource);
    }
}

