/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;

public record Transform(Vec3 offset, float scale, float rotation) {
    public static final Transform DEFAULT = new Transform(Vec3.ZERO, 1.0f, 0.0f);
    public static final Codec<Transform> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Vec3.CODEC.optionalFieldOf("offset", (Object)Vec3.ZERO).forGetter(Transform::offset), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(Transform::scale), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(Transform::rotation)).apply((Applicative)codec, Transform::new));

    public void apply(GuiGraphics graphics) {
        graphics.pose().translate(-this.offset.x, -this.offset.y, -this.offset.z);
        graphics.pose().scale(this.scale, this.scale, this.scale);
        graphics.pose().mulPose(Axis.ZP.rotationDegrees(this.rotation));
    }
}

